/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.util.ArrayList;
import java.util.List;
import org.jooq.DataType;
import org.jooq.SQLDialect;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.FieldTypeHelper;
import org.jooq.impl.SQLDataType;
import org.jooq.tools.JooqLogger;
import org.jooq.util.AbstractDefinition;
import org.jooq.util.DataTypeDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.Definition;
import org.jooq.util.TypedElementDefinition;
import org.jooq.util.jaxb.ForcedType;

abstract class AbstractTypedElementDefinition<T extends Definition>
extends AbstractDefinition
implements TypedElementDefinition<T> {
    private static final JooqLogger log = JooqLogger.getLogger(AbstractTypedElementDefinition.class);
    private final T container;
    private final DataTypeDefinition definedType;
    private transient DataTypeDefinition type;

    public AbstractTypedElementDefinition(T container, String name, int position, DataTypeDefinition definedType, String comment) {
        super(container.getDatabase(), container.getSchema(), AbstractTypedElementDefinition.protectName(container.getName(), name, position), comment);
        this.container = container;
        this.definedType = definedType;
    }

    private static String protectName(String table, String name, int position) {
        if (name == null) {
            log.warn((Object)"Missing name", (Object)("Object " + table + " holds a column without a name at position " + position));
            return "_" + position;
        }
        return name;
    }

    @Override
    public final T getContainer() {
        return this.container;
    }

    @Override
    public List<Definition> getDefinitionPath() {
        ArrayList<Definition> result = new ArrayList<Definition>();
        result.addAll(this.getContainer().getDefinitionPath());
        result.add(this);
        return result;
    }

    @Override
    public DataTypeDefinition getType() {
        if (this.type == null) {
            Database db = this.container.getDatabase();
            ForcedType forcedType = db.getConfiguredForcedType(this);
            if (forcedType != null) {
                log.debug((Object)"Forcing type", (Object)(this + " into " + forcedType.getName()));
                DataType forcedDataType = null;
                String t = this.definedType.getType();
                int l = this.definedType.getLength();
                int p = this.definedType.getPrecision();
                int s = this.definedType.getScale();
                try {
                    forcedDataType = FieldTypeHelper.getDialectDataType((SQLDialect)db.getDialect(), (String)forcedType.getName(), (int)p, (int)s);
                }
                catch (SQLDialectNotSupportedException ignore) {
                    // empty catch block
                }
                this.type = forcedDataType != null ? new DefaultDataTypeDefinition(db, this.getSchema(), forcedType.getName(), l, p, s) : new DefaultDataTypeDefinition(db, this.getSchema(), t, l, p, s, forcedType.getName());
            }
            if (db.dateAsTimestamp()) {
                DataType dataType = null;
                try {
                    dataType = FieldTypeHelper.getDialectDataType((SQLDialect)db.getDialect(), (String)this.definedType.getType(), (int)0, (int)0);
                }
                catch (SQLDialectNotSupportedException ignore) {
                    // empty catch block
                }
                if (dataType != null && dataType.getSQLType() == 91) {
                    DataType forcedDataType = FieldTypeHelper.getDialectDataType((SQLDialect)db.getDialect(), (String)SQLDataType.TIMESTAMP.getTypeName(), (int)0, (int)0);
                    this.type = new DefaultDataTypeDefinition(db, this.getSchema(), forcedDataType.getTypeName(), 0, 0, 0);
                }
            }
            if (this.type == null) {
                this.type = this.definedType;
            }
        }
        return this.type;
    }
}

