/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.util.Arrays;
import java.util.List;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.Factory;
import org.jooq.tools.JooqLogger;
import org.jooq.util.AbstractDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Definition;
import org.jooq.util.ForeignKeyDefinition;
import org.jooq.util.MasterDataTableDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UniqueKeyDefinition;
import org.jooq.util.jaxb.MasterDataTable;

public class DefaultMasterDataTableDefinition
extends AbstractDefinition
implements MasterDataTableDefinition {
    private static final JooqLogger log = JooqLogger.getLogger(DefaultMasterDataTableDefinition.class);
    private final TableDefinition delegate;
    private Result<Record> data;
    private boolean dataFetched;

    public DefaultMasterDataTableDefinition(TableDefinition delegate) {
        super(delegate.getDatabase(), delegate.getSchema(), delegate.getName(), delegate.getComment());
        this.delegate = delegate;
    }

    @Override
    public List<Definition> getDefinitionPath() {
        return Arrays.asList(this.getSchema(), this);
    }

    @Override
    public ColumnDefinition getPrimaryKeyColumn() {
        for (ColumnDefinition column : this.getColumns()) {
            if (this.getDatabase().getRelations().getPrimaryKey(column) == null) continue;
            return column;
        }
        return null;
    }

    @Override
    public ColumnDefinition getLiteralColumn() {
        String columnName = this.getConfiguredMasterDataTable().getLiteral();
        if (columnName == null) {
            columnName = this.getPrimaryKeyColumn().getName();
        }
        return this.getColumn(columnName);
    }

    @Override
    public ColumnDefinition getDescriptionColumn() {
        String columnName = this.getConfiguredMasterDataTable().getDescription();
        if (columnName == null) {
            columnName = this.getLiteralColumn().getName();
        }
        return this.getColumn(columnName);
    }

    private final MasterDataTable getConfiguredMasterDataTable() {
        for (MasterDataTable table : this.getDatabase().getConfiguredMasterDataTables()) {
            if (!table.getName().equals(this.getName())) continue;
            return table;
        }
        return null;
    }

    @Override
    public Result<Record> getData() {
        if (!this.dataFetched) {
            this.dataFetched = true;
            try {
                this.data = this.create().select(new Field[0]).from(new TableLike[]{this.delegate.getTable()}).orderBy(new Field[]{Factory.field((String)this.getPrimaryKeyColumn().getName())}).fetch();
            }
            catch (DataAccessException e) {
                log.error((Object)"Error while initialising master data", (Throwable)e);
            }
        }
        return this.data;
    }

    @Override
    public UniqueKeyDefinition getMainUniqueKey() {
        return this.delegate.getMainUniqueKey();
    }

    @Override
    public List<UniqueKeyDefinition> getUniqueKeys() {
        return this.delegate.getUniqueKeys();
    }

    @Override
    public List<ForeignKeyDefinition> getForeignKeys() {
        return this.delegate.getForeignKeys();
    }

    @Override
    public ColumnDefinition getIdentity() {
        return this.delegate.getIdentity();
    }

    @Override
    public List<ColumnDefinition> getColumns() {
        return this.delegate.getColumns();
    }

    @Override
    public ColumnDefinition getColumn(String columnName) {
        return this.delegate.getColumn(columnName);
    }

    @Override
    public ColumnDefinition getColumn(String columnName, boolean ignoreCase) {
        return this.delegate.getColumn(columnName, ignoreCase);
    }

    @Override
    public ColumnDefinition getColumn(int columnIndex) {
        return this.delegate.getColumn(columnIndex);
    }

    @Override
    public Table<Record> getTable() {
        return this.delegate.getTable();
    }
}

