/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.ase;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.TableLike;
import org.jooq.impl.Factory;
import org.jooq.tools.JooqLogger;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.EnumDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.ase.ASETableDefinition;
import org.jooq.util.ase.sys.DboFactory;
import org.jooq.util.ase.sys.tables.Sysindexes;
import org.jooq.util.ase.sys.tables.Sysreferences;

public class ASEDatabase
extends AbstractDatabase {
    private static final JooqLogger log = JooqLogger.getLogger(ASEDatabase.class);
    private static final int PK_INCL = 2048;
    private static final int PK_EXCL = 64;
    private static final int UK_INCL = 4098;
    private static final int UK_EXCL = 2112;

    @Override
    public Factory create() {
        return new DboFactory(this.getConnection());
    }

    private SchemaDefinition getSchema() {
        List<SchemaDefinition> schemata = this.getSchemata();
        if (schemata.size() > 1) {
            log.error((Object)"NOT SUPPORTED", (Object)"jOOQ does not support multiple schemata in Sybase ASE.");
            log.error((Object)"-----------------------------------------------------------------------");
        }
        return schemata.get(0);
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys(2048, 64)) {
            String keyName = record.getValueAsString(0);
            TableDefinition table = this.getTable(this.getSchema(), record.getValueAsString(1));
            if (table == null) continue;
            for (int i = 0; i < 8 && record.getValue(2 + i) != null; ++i) {
                relations.addPrimaryKey(keyName, table.getColumn(record.getValueAsString(2 + i)));
            }
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys(4098, 2112)) {
            String keyName = record.getValueAsString(0);
            TableDefinition table = this.getTable(this.getSchema(), record.getValueAsString(1));
            if (table == null) continue;
            for (int i = 0; i < 8 && record.getValue(2 + i) != null; ++i) {
                relations.addUniqueKey(keyName, table.getColumn(record.getValueAsString(2 + i)));
            }
        }
    }

    private List<Record> fetchKeys(int incl, int excl) {
        Field table = Factory.field((String)"object_name(id)", String.class);
        Field key = Factory.field((String)"name", String.class);
        return this.create().select(new Field[]{Factory.concat((Field[])new Field[]{table, Factory.val((Object)"__"), key}), table, Factory.field((String)"index_col(object_name(id), indid, 1)", String.class), Factory.field((String)"index_col(object_name(id), indid, 2)", String.class), Factory.field((String)"index_col(object_name(id), indid, 3)", String.class), Factory.field((String)"index_col(object_name(id), indid, 4)", String.class), Factory.field((String)"index_col(object_name(id), indid, 5)", String.class), Factory.field((String)"index_col(object_name(id), indid, 6)", String.class), Factory.field((String)"index_col(object_name(id), indid, 7)", String.class), Factory.field((String)"index_col(object_name(id), indid, 8)", String.class)}).from(new TableLike[]{Sysindexes.SYSINDEXES}).where("status & ? = 0", new Object[]{excl}).and("status & ? <> 0", new Object[]{incl}).orderBy(new Field[]{Sysindexes.ID}).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations) throws SQLException {
        Field fkTable = Factory.field((String)"object_name(tableid)", String.class);
        Field fk = Factory.field((String)"object_name(constrid)", String.class);
        Field pkTable = Factory.field((String)"object_name(reftabid)", String.class);
        Field pk = Factory.field((String)"index_name(pmrydbid, reftabid, indexid)", String.class);
        for (Record record : this.create().select(new Field[]{fkTable.as("fk_table"), Factory.concat((Field[])new Field[]{fkTable, Factory.val((Object)"__"), fk}).as("fk"), Factory.concat((Field[])new Field[]{pkTable, Factory.val((Object)"__"), pk}).as("pk"), Factory.field((String)"col_name(tableid, fokey1)", String.class), Factory.field((String)"col_name(tableid, fokey2)", String.class), Factory.field((String)"col_name(tableid, fokey3)", String.class), Factory.field((String)"col_name(tableid, fokey4)", String.class), Factory.field((String)"col_name(tableid, fokey5)", String.class), Factory.field((String)"col_name(tableid, fokey6)", String.class), Factory.field((String)"col_name(tableid, fokey7)", String.class), Factory.field((String)"col_name(tableid, fokey8)", String.class), Factory.field((String)"col_name(tableid, fokey9)", String.class), Factory.field((String)"col_name(tableid, fokey10)", String.class), Factory.field((String)"col_name(tableid, fokey11)", String.class), Factory.field((String)"col_name(tableid, fokey12)", String.class), Factory.field((String)"col_name(tableid, fokey13)", String.class), Factory.field((String)"col_name(tableid, fokey14)", String.class), Factory.field((String)"col_name(tableid, fokey15)", String.class), Factory.field((String)"col_name(tableid, fokey16)", String.class), Factory.field((String)"object_owner_id(tableid)")}).from(new TableLike[]{Sysreferences.SYSREFERENCES}).fetch()) {
            TableDefinition referencingTable = this.getTable(this.getSchema(), record.getValueAsString("fk_table"));
            if (referencingTable == null) continue;
            for (int i = 0; i < 16 && record.getValue(i + 3) != null; ++i) {
                String foreignKeyName = record.getValueAsString("fk");
                String foreignKeyColumnName = record.getValueAsString(i + 3);
                String uniqueKeyName = record.getValueAsString("pk");
                ColumnDefinition column = referencingTable.getColumn(foreignKeyColumnName);
                relations.addForeignKey(foreignKeyName, uniqueKeyName, column, this.getSchema());
            }
        }
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.fetchTables()) {
            SchemaDefinition schema = this.getSchema(record.getValueAsString("Owner"));
            String name = record.getValueAsString("Name");
            result.add(new ASETableDefinition(schema, name, null));
        }
        return result;
    }

    private List<Record> fetchTables() {
        ArrayList<Record> result = new ArrayList<Record>();
        for (Record record : this.create().fetch("sp_help")) {
            if (!Arrays.asList("view", "user table", "system table").contains(record.getValueAsString("Object_type")) || !this.getInputSchemata().contains(record.getValueAsString("Owner"))) continue;
            result.add(record);
        }
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }
}

