/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.cubrid;

import java.math.BigInteger;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SortField;
import org.jooq.TableLike;
import org.jooq.impl.Factory;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DataTypeDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.DefaultSequenceDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.cubrid.CUBRIDFactory;
import org.jooq.util.cubrid.CUBRIDTableDefinition;
import org.jooq.util.cubrid.dba.Tables;

public class CUBRIDDatabase
extends AbstractDatabase {
    @Override
    protected void loadPrimaryKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys(Tables.DB_INDEX.IS_UNIQUE.isTrue().and(Tables.DB_INDEX.IS_PRIMARY_KEY.isFalse()))) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Tables.DB_CLASS.OWNER_NAME));
            String key = (String)record.getValue("constraint_name", String.class);
            String tableName = (String)record.getValue(Tables.DB_CLASS.CLASS_NAME);
            String columnName = (String)record.getValue(Tables.DB_INDEX_KEY.KEY_ATTR_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations.addUniqueKey(key, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys(Tables.DB_INDEX.IS_PRIMARY_KEY.isTrue())) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Tables.DB_CLASS.OWNER_NAME));
            String key = (String)record.getValue("constraint_name", String.class);
            String tableName = (String)record.getValue(Tables.DB_CLASS.CLASS_NAME);
            String columnName = (String)record.getValue(Tables.DB_INDEX_KEY.KEY_ATTR_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations.addPrimaryKey(key, table.getColumn(columnName));
        }
    }

    private Result<Record> fetchKeys(Condition condition) {
        return this.create().select(new Field[]{Factory.concat((Field[])new Field[]{Tables.DB_CLASS.CLASS_NAME, Factory.val((Object)"__"), Tables.DB_INDEX.INDEX_NAME}).as("constraint_name"), Tables.DB_INDEX_KEY.KEY_ATTR_NAME, Tables.DB_CLASS.CLASS_NAME, Tables.DB_CLASS.OWNER_NAME}).from(new TableLike[]{Tables.DB_INDEX}).join((TableLike)Tables.DB_CLASS).on(new Condition[]{Tables.DB_INDEX.CLASS_NAME.equal(Tables.DB_CLASS.CLASS_NAME)}).join((TableLike)Tables.DB_INDEX_KEY).on(new Condition[]{Tables.DB_INDEX_KEY.INDEX_NAME.equal(Tables.DB_INDEX.INDEX_NAME).and(Tables.DB_INDEX_KEY.CLASS_NAME.equal(Tables.DB_INDEX.CLASS_NAME))}).where(new Condition[]{condition}).and(Tables.DB_CLASS.OWNER_NAME.in(this.getInputSchemata())).orderBy(new SortField[]{Tables.DB_CLASS.OWNER_NAME.asc(), Tables.DB_INDEX.INDEX_NAME.asc()}).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations) throws SQLException {
        DatabaseMetaData meta = this.create().getConnection().getMetaData();
        for (String table : this.create().selectDistinct(new Field[]{Tables.DB_INDEX.CLASS_NAME}).from(new TableLike[]{Tables.DB_INDEX}).where(new Condition[]{Tables.DB_INDEX.IS_FOREIGN_KEY.isTrue()}).fetch(Tables.DB_INDEX.CLASS_NAME)) {
            for (Record record : this.create().fetch(meta.getImportedKeys(null, null, table))) {
                SchemaDefinition foreignKeySchema = this.getSchema(this.getInputSchemata().get(0));
                SchemaDefinition uniqueKeySchema = this.getSchema(this.getInputSchemata().get(0));
                String foreignKeyName = (String)record.getValue("FKTABLE_NAME", String.class) + "__" + (String)record.getValue("FK_NAME", String.class);
                String foreignKeyTableName = (String)record.getValue("FKTABLE_NAME", String.class);
                String foreignKeyColumnName = (String)record.getValue("FKCOLUMN_NAME", String.class);
                String uniqueKeyName = (String)record.getValue("PKTABLE_NAME", String.class) + "__" + (String)record.getValue("PK_NAME", String.class);
                TableDefinition referencingTable = this.getTable(foreignKeySchema, foreignKeyTableName);
                if (referencingTable == null) continue;
                ColumnDefinition column = referencingTable.getColumn(foreignKeyColumnName);
                relations.addForeignKey(foreignKeyName, uniqueKeyName, column, uniqueKeySchema);
            }
        }
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.create().select(new Field[]{Tables.DB_SERIAL.NAME, Tables.DB_SERIAL.MAX_VAL, Factory.field((String)"owner.name", String.class).as("owner")}).from(new TableLike[]{Tables.DB_SERIAL}).where(new Condition[]{Factory.field((String)"owner.name", String.class).in(this.getInputSchemata())}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue("owner", String.class));
            BigInteger value = (BigInteger)record.getValue(Tables.DB_SERIAL.MAX_VAL, BigInteger.class, (Object)BigInteger.valueOf(Long.MAX_VALUE));
            DataTypeDefinition type = this.getDataTypeForMAX_VAL(schema, value);
            result.add(new DefaultSequenceDefinition(schema, (String)record.getValue(Tables.DB_SERIAL.NAME), type));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(new Field[]{Tables.DB_CLASS.OWNER_NAME, Tables.DB_CLASS.CLASS_NAME}).from(new TableLike[]{Tables.DB_CLASS}).where(new Condition[]{Tables.DB_CLASS.OWNER_NAME.in(this.getInputSchemata())}).orderBy(new SortField[]{Tables.DB_CLASS.OWNER_NAME.asc(), Tables.DB_CLASS.CLASS_NAME.asc()}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Tables.DB_CLASS.OWNER_NAME));
            String name = (String)record.getValue(Tables.DB_CLASS.CLASS_NAME);
            CUBRIDTableDefinition table = new CUBRIDTableDefinition(schema, name, null);
            result.add(table);
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    public Factory create() {
        return new CUBRIDFactory(this.getConnection());
    }
}

