/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.derby;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.TableLike;
import org.jooq.impl.Factory;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.DefaultSequenceDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.derby.DerbyTableDefinition;
import org.jooq.util.derby.sys.SysFactory;
import org.jooq.util.derby.sys.tables.Sysconglomerates;
import org.jooq.util.derby.sys.tables.Sysconstraints;
import org.jooq.util.derby.sys.tables.Syskeys;
import org.jooq.util.derby.sys.tables.Sysschemas;
import org.jooq.util.derby.sys.tables.Syssequences;
import org.jooq.util.derby.sys.tables.Systables;

public class DerbyDatabase
extends AbstractDatabase {
    @Override
    protected void loadPrimaryKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys("P")) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Sysschemas.SCHEMANAME));
            String key = (String)record.getValue(Sysconstraints.CONSTRAINTNAME);
            String tableName = (String)record.getValue(Systables.TABLENAME);
            String descriptor = record.getValueAsString(Sysconglomerates.DESCRIPTOR);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            for (int index : this.decode(descriptor)) {
                relations.addPrimaryKey(key, table.getColumn(index));
            }
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys("U")) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Sysschemas.SCHEMANAME));
            String key = (String)record.getValue(Sysconstraints.CONSTRAINTNAME);
            String tableName = (String)record.getValue(Systables.TABLENAME);
            String descriptor = record.getValueAsString(Sysconglomerates.DESCRIPTOR);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            for (int index : this.decode(descriptor)) {
                relations.addUniqueKey(key, table.getColumn(index));
            }
        }
    }

    private List<Record> fetchKeys(String constraintType) {
        return this.create().select(new Field[]{Sysschemas.SCHEMANAME, Systables.TABLENAME, Systables.TABLEID, Sysconstraints.CONSTRAINTNAME, Sysconglomerates.DESCRIPTOR}).from(new TableLike[]{Sysconglomerates.SYSCONGLOMERATES}).join((TableLike)Syskeys.SYSKEYS).on(new Condition[]{Syskeys.CONGLOMERATEID.equal(Sysconglomerates.CONGLOMERATEID)}).join((TableLike)Sysconstraints.SYSCONSTRAINTS).on(new Condition[]{Sysconstraints.CONSTRAINTID.equal(Syskeys.CONSTRAINTID)}).join((TableLike)Systables.SYSTABLES).on(new Condition[]{Systables.TABLEID.equal(Sysconglomerates.TABLEID)}).join((TableLike)Sysschemas.SYSSCHEMAS).on(new Condition[]{Sysschemas.SCHEMAID.equal(Systables.SCHEMAID)}).and(Sysschemas.SCHEMANAME.in(this.getInputSchemata())).where(new Condition[]{Sysconstraints.TYPE.equal((Object)constraintType)}).orderBy(new Field[]{Sysschemas.SCHEMANAME, Systables.TABLENAME, Sysconstraints.CONSTRAINTNAME}).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations) throws SQLException {
        Field fkName = Factory.field((String)"fc.constraintname", String.class);
        Field fkTable = Factory.field((String)"ft.tablename", String.class);
        Field fkSchema = Factory.field((String)"fs.schemaname", String.class);
        Field fkDescriptor = Factory.field((String)"fg.descriptor");
        Field ukName = Factory.field((String)"pc.constraintname", String.class);
        Field ukSchema = Factory.field((String)"ps.schemaname", String.class);
        for (Record record : this.create().select(new Field[]{fkName, fkTable, fkSchema, fkDescriptor, ukName, ukSchema}).from("sys.sysconstraints   fc").join("sys.sysforeignkeys   f ").on("f.constraintid = fc.constraintid").join("sys.sysconglomerates fg").on("fg.conglomerateid = f.conglomerateid").join("sys.systables        ft").on("ft.tableid = fg.tableid").join("sys.sysschemas       fs").on("ft.schemaid = fs.schemaid").join("sys.sysconstraints   pc").on("pc.constraintid = f.keyconstraintid").join("sys.sysschemas       ps").on("pc.schemaid = ps.schemaid").where("fc.type = 'F'").fetch()) {
            SchemaDefinition foreignKeySchema = this.getSchema((String)record.getValue(fkSchema));
            SchemaDefinition uniqueKeySchema = this.getSchema((String)record.getValue(ukSchema));
            String foreignKeyName = (String)record.getValue(fkName);
            String foreignKeyTableName = (String)record.getValue(fkTable);
            List<Integer> foreignKeyIndexes = this.decode(record.getValueAsString(fkDescriptor));
            String uniqueKeyName = (String)record.getValue(ukName);
            TableDefinition referencingTable = this.getTable(foreignKeySchema, foreignKeyTableName);
            if (referencingTable == null) continue;
            for (int i = 0; i < foreignKeyIndexes.size(); ++i) {
                ColumnDefinition column = referencingTable.getColumn(foreignKeyIndexes.get(i));
                relations.addForeignKey(foreignKeyName, uniqueKeyName, column, uniqueKeySchema);
            }
        }
    }

    private List<Integer> decode(String descriptor) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Pattern p = Pattern.compile(".*?\\((.*?)\\)");
        Matcher m = p.matcher(descriptor);
        while (m.find()) {
            String[] split = m.group(1).split(",");
            if (split == null) continue;
            for (String index : split) {
                result.add(Integer.valueOf(index.trim()) - 1);
            }
        }
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.create().select(new Field[]{Sysschemas.SCHEMANAME, Syssequences.SEQUENCENAME, Syssequences.SEQUENCEDATATYPE}).from(new TableLike[]{Syssequences.SYSSEQUENCES}).join((TableLike)Sysschemas.SYSSCHEMAS).on(new Condition[]{Sysschemas.SCHEMAID.equal(Syssequences.SCHEMAID)}).where(new Condition[]{Sysschemas.SCHEMANAME.in(this.getInputSchemata())}).orderBy(new Field[]{Sysschemas.SCHEMANAME, Syssequences.SEQUENCENAME}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Sysschemas.SCHEMANAME));
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, schema, (String)record.getValue(Syssequences.SEQUENCEDATATYPE), 0, 0, 0);
            result.add(new DefaultSequenceDefinition(schema, record.getValueAsString(Syssequences.SEQUENCENAME), type));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(new Field[]{Sysschemas.SCHEMANAME, Systables.TABLENAME, Systables.TABLEID}).from(new TableLike[]{Systables.SYSTABLES}).join((TableLike)Sysschemas.SYSSCHEMAS).on(new Condition[]{Systables.SCHEMAID.equal(Sysschemas.SCHEMAID)}).where(new Condition[]{Sysschemas.SCHEMANAME.in(this.getInputSchemata())}).orderBy(new Field[]{Sysschemas.SCHEMANAME, Systables.TABLENAME}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Sysschemas.SCHEMANAME));
            String name = (String)record.getValue(Systables.TABLENAME);
            String id = (String)record.getValue(Systables.TABLEID);
            DerbyTableDefinition table = new DerbyTableDefinition(schema, name, id);
            result.add(table);
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    public Factory create() {
        return new SysFactory(this.getConnection());
    }
}

