/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.hsqldb;

import java.sql.SQLException;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SortField;
import org.jooq.TableLike;
import org.jooq.impl.Factory;
import org.jooq.tools.StringUtils;
import org.jooq.util.AbstractRoutineDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.DefaultParameterDefinition;
import org.jooq.util.InOutDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.hsqldb.information_schema.Tables;

public class HSQLDBRoutineDefinition
extends AbstractRoutineDefinition {
    private final String specificName;

    public HSQLDBRoutineDefinition(SchemaDefinition schema, String name, String specificName, String dataType, Number precision, Number scale) {
        super(schema, null, name, null, null);
        if (!StringUtils.isBlank((String)dataType)) {
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), dataType, precision, precision, scale);
            this.returnValue = new DefaultParameterDefinition(this, "RETURN_VALUE", -1, type);
        }
        this.specificName = specificName;
    }

    @Override
    protected void init0() throws SQLException {
        Result result = this.create().select(new Field[]{Tables.PARAMETERS.PARAMETER_MODE, Tables.PARAMETERS.PARAMETER_NAME, Factory.nvl(Tables.ELEMENT_TYPES.COLLECTION_TYPE_IDENTIFIER, Tables.PARAMETERS.DATA_TYPE).as("datatype"), Tables.PARAMETERS.CHARACTER_MAXIMUM_LENGTH, Tables.PARAMETERS.NUMERIC_PRECISION, Tables.PARAMETERS.NUMERIC_SCALE, Tables.PARAMETERS.ORDINAL_POSITION}).from(new TableLike[]{Tables.PARAMETERS}).join((TableLike)Tables.ROUTINES).on(new Condition[]{Tables.PARAMETERS.SPECIFIC_SCHEMA.equal(Tables.ROUTINES.SPECIFIC_SCHEMA)}).and(Tables.PARAMETERS.SPECIFIC_NAME.equal(Tables.ROUTINES.SPECIFIC_NAME)).leftOuterJoin((TableLike)Tables.ELEMENT_TYPES).on(new Condition[]{Tables.ROUTINES.ROUTINE_SCHEMA.equal(Tables.ELEMENT_TYPES.OBJECT_SCHEMA)}).and(Tables.ROUTINES.ROUTINE_NAME.equal(Tables.ELEMENT_TYPES.OBJECT_NAME)).and(Tables.PARAMETERS.DTD_IDENTIFIER.equal(Tables.ELEMENT_TYPES.COLLECTION_TYPE_IDENTIFIER)).where(new Condition[]{Tables.PARAMETERS.SPECIFIC_SCHEMA.equal((Object)this.getSchema().getName())}).and(Tables.PARAMETERS.SPECIFIC_NAME.equal((Object)this.specificName)).orderBy(new SortField[]{Tables.PARAMETERS.ORDINAL_POSITION.asc()}).fetch();
        for (Record record : result) {
            String inOut = (String)record.getValue(Tables.PARAMETERS.PARAMETER_MODE);
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), record.getValueAsString("datatype"), (Number)record.getValue(Tables.PARAMETERS.CHARACTER_MAXIMUM_LENGTH), (Number)record.getValue(Tables.PARAMETERS.NUMERIC_PRECISION), (Number)record.getValue(Tables.PARAMETERS.NUMERIC_SCALE));
            DefaultParameterDefinition parameter = new DefaultParameterDefinition(this, ((String)record.getValue(Tables.PARAMETERS.PARAMETER_NAME)).replaceAll("@", ""), record.getValueAsInteger(Tables.PARAMETERS.ORDINAL_POSITION), type);
            this.addParameter(InOutDefinition.getFromString(inOut), parameter);
        }
    }
}

