/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.mysql;

import java.sql.SQLException;
import java.util.regex.Matcher;
import org.jooq.tools.StringUtils;
import org.jooq.util.AbstractRoutineDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.DefaultParameterDefinition;
import org.jooq.util.InOutDefinition;
import org.jooq.util.ParameterDefinition;
import org.jooq.util.SchemaDefinition;

public class MySQLRoutineDefinition
extends AbstractRoutineDefinition {
    private final String params;
    private final String returns;

    public MySQLRoutineDefinition(SchemaDefinition schema, String name, String comment, String params, String returns) {
        super(schema, null, name, comment, null);
        this.params = params;
        this.returns = returns;
    }

    @Override
    protected void init0() throws SQLException {
        String[] split = this.params.split(",(?!\\s*\\d+\\s*\\))");
        Matcher matcher = TYPE_PATTERN.matcher(this.returns);
        if (matcher.find()) {
            this.addParameter(InOutDefinition.RETURN, this.createParameter(matcher, 0, -1, "RETURN_VALUE"));
        }
        for (int i = 0; i < split.length; ++i) {
            String param = split[i];
            param = param.trim();
            matcher = PARAMETER_PATTERN.matcher(param);
            while (matcher.find()) {
                InOutDefinition inOut = InOutDefinition.getFromString(matcher.group(2));
                this.addParameter(inOut, this.createParameter(matcher, 3, i + 1));
            }
        }
    }

    private ParameterDefinition createParameter(Matcher matcher, int group, int columnIndex) {
        return this.createParameter(matcher, group, columnIndex, matcher.group(group));
    }

    private ParameterDefinition createParameter(Matcher matcher, int group, int columnIndex, String paramName) {
        String paramType = matcher.group(group + 1);
        Integer precision = 0;
        Integer scale = 0;
        if (!StringUtils.isBlank((String)matcher.group(group + 2))) {
            precision = Integer.valueOf(matcher.group(group + 2));
        }
        if (!StringUtils.isBlank((String)matcher.group(group + 3))) {
            scale = Integer.valueOf(matcher.group(group + 3));
        }
        DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), paramType, precision, precision, scale);
        return new DefaultParameterDefinition(this, paramName, columnIndex, type);
    }
}

