/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.sqlite;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.TableLike;
import org.jooq.impl.Factory;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.EnumDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.jaxb.Schema;
import org.jooq.util.sqlite.SQLiteFactory;
import org.jooq.util.sqlite.SQLiteTableDefinition;
import org.jooq.util.sqlite.sqlite_master.SQLiteMaster;

public class SQLiteDatabase
extends AbstractDatabase {
    public SQLiteDatabase() {
        Schema schema = new Schema();
        schema.setInputSchema("");
        schema.setOutputSchema("");
        ArrayList<Schema> schemata = new ArrayList<Schema>();
        schemata.add(schema);
        this.setConfiguredSchemata(schemata);
    }

    @Override
    public Factory create() {
        return new SQLiteFactory(this.getConnection());
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations) throws SQLException {
        for (String tableName : this.create().select(new Field[]{SQLiteMaster.NAME}).from(new TableLike[]{SQLiteMaster.SQLITE_MASTER}).where(new Condition[]{SQLiteMaster.TYPE.in((Object[])new String[]{"table"})}).orderBy(new Field[]{SQLiteMaster.NAME}).fetch(SQLiteMaster.NAME)) {
            for (Record record : this.create().fetch("pragma table_info('" + tableName + "')")) {
                if (!record.getValueAsBoolean("pk", Boolean.valueOf(false)).booleanValue()) continue;
                String columnName = record.getValueAsString("name");
                String key = "pk_" + tableName + "_" + columnName;
                TableDefinition table = this.getTable(this.getSchemata().get(0), tableName);
                if (table == null) continue;
                ColumnDefinition column = table.getColumn(columnName);
                relations.addPrimaryKey(key, column);
            }
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations r) throws SQLException {
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations) throws SQLException {
        for (TableDefinition table : this.getTables(this.getSchemata().get(0))) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (Record record : this.create().fetch("pragma foreign_key_list(" + table.getName() + ")")) {
                String foreignKeyPrefix = "fk_" + table.getName() + "_" + record.getValue("table");
                Integer sequence = (Integer)map.get(foreignKeyPrefix);
                if (sequence == null) {
                    sequence = 0;
                }
                if (0 == (Integer)record.getValue("seq", Integer.class)) {
                    sequence = sequence + 1;
                }
                map.put(foreignKeyPrefix, sequence);
                String foreignKey = "fk_" + table.getName() + "_" + record.getValue("table") + "_" + sequence;
                String foreignKeyTable = table.getName();
                String foreignKeyColumn = record.getValueAsString("from");
                TableDefinition referencingTable = this.getTable(this.getSchemata().get(0), foreignKeyTable);
                TableDefinition referencedTable = this.getTable(this.getSchemata().get(0), record.getValueAsString("table"), true);
                if (referencedTable == null) continue;
                String uniqueKey = "pk_" + referencedTable.getName() + "_" + referencedTable.getColumn(record.getValueAsString("to"), true).getName();
                if (referencingTable == null) continue;
                ColumnDefinition referencingColumn = referencingTable.getColumn(foreignKeyColumn);
                relations.addForeignKey(foreignKey, uniqueKey, referencingColumn, this.getSchemata().get(0));
            }
        }
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (String name : this.create().select(new Field[]{SQLiteMaster.NAME}).from(new TableLike[]{SQLiteMaster.SQLITE_MASTER}).where(new Condition[]{SQLiteMaster.TYPE.in((Object[])new String[]{"table", "view"})}).orderBy(new Field[]{SQLiteMaster.NAME}).fetch(SQLiteMaster.NAME)) {
            SQLiteTableDefinition table = new SQLiteTableDefinition(this.getSchemata().get(0), name, "");
            result.add(table);
        }
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }
}

