/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.sqlserver;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SortField;
import org.jooq.TableLike;
import org.jooq.impl.Factory;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.EnumDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.sqlserver.SQLServerFactory;
import org.jooq.util.sqlserver.SQLServerRoutineDefinition;
import org.jooq.util.sqlserver.SQLServerTableDefinition;
import org.jooq.util.sqlserver.information_schema.Tables;

public class SQLServerDatabase
extends AbstractDatabase {
    @Override
    public Factory create() {
        return new SQLServerFactory(this.getConnection());
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys("PRIMARY KEY")) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA));
            String key = (String)record.getValue(Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME);
            String tableName = (String)record.getValue(Tables.KEY_COLUMN_USAGE.TABLE_NAME);
            String columnName = (String)record.getValue(Tables.KEY_COLUMN_USAGE.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations.addPrimaryKey(key, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys("UNIQUE")) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA));
            String key = (String)record.getValue(Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME);
            String tableName = (String)record.getValue(Tables.KEY_COLUMN_USAGE.TABLE_NAME);
            String columnName = (String)record.getValue(Tables.KEY_COLUMN_USAGE.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations.addUniqueKey(key, table.getColumn(columnName));
        }
    }

    private List<Record> fetchKeys(String constraintType) {
        return this.create().select(new Field[]{Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA, Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME, Tables.KEY_COLUMN_USAGE.TABLE_NAME, Tables.KEY_COLUMN_USAGE.COLUMN_NAME}).from(new TableLike[]{Tables.TABLE_CONSTRAINTS}).join((TableLike)Tables.KEY_COLUMN_USAGE).on(new Condition[]{Tables.TABLE_CONSTRAINTS.TABLE_SCHEMA.equal(Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA)}).and(Tables.TABLE_CONSTRAINTS.CONSTRAINT_NAME.equal(Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME)).where(new Condition[]{Tables.TABLE_CONSTRAINTS.CONSTRAINT_TYPE.equal((Object)constraintType)}).and(Tables.TABLE_CONSTRAINTS.TABLE_SCHEMA.in(this.getInputSchemata())).orderBy(new SortField[]{Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA.asc(), Tables.KEY_COLUMN_USAGE.TABLE_NAME.asc(), Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME.asc(), Tables.KEY_COLUMN_USAGE.ORDINAL_POSITION.asc()}).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations) throws SQLException {
        Result result = this.create().select(new Field[]{Tables.REFERENTIAL_CONSTRAINTS.CONSTRAINT_NAME, Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_NAME, Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_SCHEMA, Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA, Tables.KEY_COLUMN_USAGE.TABLE_NAME, Tables.KEY_COLUMN_USAGE.COLUMN_NAME}).from(new TableLike[]{Tables.REFERENTIAL_CONSTRAINTS}).join((TableLike)Tables.KEY_COLUMN_USAGE).on(new Condition[]{Tables.REFERENTIAL_CONSTRAINTS.CONSTRAINT_SCHEMA.equal(Tables.KEY_COLUMN_USAGE.CONSTRAINT_SCHEMA)}).and(Tables.REFERENTIAL_CONSTRAINTS.CONSTRAINT_NAME.equal(Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME)).where(new Condition[]{Tables.REFERENTIAL_CONSTRAINTS.CONSTRAINT_SCHEMA.in(this.getInputSchemata())}).orderBy(new SortField[]{Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA.asc(), Tables.KEY_COLUMN_USAGE.TABLE_NAME.asc(), Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME.asc(), Tables.KEY_COLUMN_USAGE.ORDINAL_POSITION.asc()}).fetch();
        for (Record record : result) {
            SchemaDefinition foreignKeySchema = this.getSchema((String)record.getValue(Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA));
            SchemaDefinition uniqueKeySchema = this.getSchema((String)record.getValue(Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_SCHEMA));
            String foreignKey = (String)record.getValue(Tables.REFERENTIAL_CONSTRAINTS.CONSTRAINT_NAME);
            String foreignKeyTable = (String)record.getValue(Tables.KEY_COLUMN_USAGE.TABLE_NAME);
            String foreignKeyColumn = (String)record.getValue(Tables.KEY_COLUMN_USAGE.COLUMN_NAME);
            String uniqueKey = (String)record.getValue(Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_NAME);
            TableDefinition referencingTable = this.getTable(foreignKeySchema, foreignKeyTable);
            if (referencingTable == null) continue;
            ColumnDefinition referencingColumn = referencingTable.getColumn(foreignKeyColumn);
            relations.addForeignKey(foreignKey, uniqueKey, referencingColumn, uniqueKeySchema);
        }
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        return Collections.emptyList();
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(new Field[]{Tables.TABLES.TABLE_SCHEMA, Tables.TABLES.TABLE_NAME}).from(new TableLike[]{Tables.TABLES}).where(new Condition[]{Tables.TABLES.TABLE_SCHEMA.in(this.getInputSchemata())}).orderBy(new Field[]{Tables.TABLES.TABLE_SCHEMA, Tables.TABLES.TABLE_NAME}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Tables.TABLES.TABLE_SCHEMA));
            String name = (String)record.getValue(Tables.TABLES.TABLE_NAME);
            String comment = "";
            result.add(new SQLServerTableDefinition(schema, name, comment));
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        for (Record record : this.create().selectDistinct(new Field[]{Tables.ROUTINES.ROUTINE_SCHEMA, Tables.ROUTINES.ROUTINE_NAME, Tables.ROUTINES.SPECIFIC_NAME, Tables.ROUTINES.DATA_TYPE, Tables.ROUTINES.CHARACTER_MAXIMUM_LENGTH, Tables.ROUTINES.NUMERIC_PRECISION, Tables.ROUTINES.NUMERIC_SCALE}).from(new TableLike[]{Tables.ROUTINES}).where(new Condition[]{Tables.ROUTINES.ROUTINE_SCHEMA.in(this.getInputSchemata())}).orderBy(new Field[]{Tables.ROUTINES.ROUTINE_SCHEMA, Tables.ROUTINES.ROUTINE_NAME}).fetch()) {
            SQLServerRoutineDefinition routine = new SQLServerRoutineDefinition(this.getSchema((String)record.getValue(Tables.ROUTINES.ROUTINE_SCHEMA)), (String)record.getValue(Tables.ROUTINES.ROUTINE_NAME), (String)record.getValue(Tables.ROUTINES.SPECIFIC_NAME), (String)record.getValue(Tables.ROUTINES.DATA_TYPE), (Number)record.getValue(Tables.ROUTINES.CHARACTER_MAXIMUM_LENGTH), (Number)record.getValue(Tables.ROUTINES.NUMERIC_PRECISION), (Number)record.getValue(Tables.ROUTINES.NUMERIC_SCALE));
            result.add(routine);
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }
}

