/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.sybase;

import java.sql.SQLException;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.TableLike;
import org.jooq.util.AbstractRoutineDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.DefaultParameterDefinition;
import org.jooq.util.InOutDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.sybase.sys.Tables;

public class SybaseRoutineDefinition
extends AbstractRoutineDefinition {
    public SybaseRoutineDefinition(SchemaDefinition schema, PackageDefinition pkg, String name) {
        super(schema, pkg, name, null, null);
    }

    @Override
    protected void init0() throws SQLException {
        for (Record record : this.create().select(new Field[]{Tables.SYSPROCPARM.PARM_NAME, Tables.SYSDOMAIN.DOMAIN_NAME, Tables.SYSPROCPARM.WIDTH, Tables.SYSPROCPARM.SCALE, Tables.SYSPROCPARM.PARM_ID, Tables.SYSPROCPARM.PARM_TYPE, Tables.SYSPROCPARM.PARM_MODE_IN, Tables.SYSPROCPARM.PARM_MODE_OUT}).from(new TableLike[]{Tables.SYSPROCPARM}).join((TableLike)Tables.SYSDOMAIN).on(new Condition[]{Tables.SYSPROCPARM.DOMAIN_ID.equal(Tables.SYSDOMAIN.DOMAIN_ID)}).join((TableLike)Tables.SYSPROCEDURE).on(new Condition[]{Tables.SYSPROCPARM.PROC_ID.equal(Tables.SYSPROCEDURE.PROC_ID)}).where(new Condition[]{Tables.SYSPROCEDURE.PROC_NAME.equal((Object)this.getName())}).orderBy(new Field[]{Tables.SYSPROCPARM.PARM_ID}).fetch()) {
            InOutDefinition inOutDefinition;
            String paramName = (String)record.getValue(Tables.SYSPROCPARM.PARM_NAME);
            Boolean paramModeIn = record.getValueAsBoolean(Tables.SYSPROCPARM.PARM_MODE_IN, Boolean.valueOf(false));
            Boolean paramModeOut = record.getValueAsBoolean(Tables.SYSPROCPARM.PARM_MODE_OUT, Boolean.valueOf(false));
            short parmType = (Short)record.getValue(Tables.SYSPROCPARM.PARM_TYPE);
            if (parmType == 4) {
                inOutDefinition = InOutDefinition.RETURN;
                paramName = "RETURN_VALUE";
            } else if (paramModeIn.booleanValue() && paramModeOut.booleanValue()) {
                inOutDefinition = InOutDefinition.INOUT;
            } else if (paramModeIn.booleanValue()) {
                inOutDefinition = InOutDefinition.IN;
            } else if (paramModeOut.booleanValue()) {
                inOutDefinition = InOutDefinition.OUT;
            } else {
                throw new IllegalArgumentException("Stored procedure param is neither in or out mode!");
            }
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), (String)record.getValue(Tables.SYSDOMAIN.DOMAIN_NAME), (Number)record.getValue(Tables.SYSPROCPARM.WIDTH), (Number)record.getValue(Tables.SYSPROCPARM.WIDTH), (Number)record.getValue(Tables.SYSPROCPARM.SCALE));
            DefaultParameterDefinition parameter = new DefaultParameterDefinition(this, paramName, ((Short)record.getValue(Tables.SYSPROCPARM.PARM_ID)).shortValue(), type);
            this.addParameter(inOutDefinition, parameter);
        }
    }
}

