/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.impl.TableImpl;
import org.jooq.meta.AbstractElementContainerDefinition;
import org.jooq.meta.CheckConstraintDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DefaultIdentityDefinition;
import org.jooq.meta.DefaultManyToManyKeyDefinition;
import org.jooq.meta.EmbeddableDefinition;
import org.jooq.meta.ForeignKeyDefinition;
import org.jooq.meta.IdentityDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.InverseForeignKeyDefinition;
import org.jooq.meta.ManyToManyKeyDefinition;
import org.jooq.meta.ParameterDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UniqueKeyDefinition;

public abstract class AbstractTableDefinition
extends AbstractElementContainerDefinition<ColumnDefinition>
implements TableDefinition {
    private List<ParameterDefinition> parameters;
    private TableDefinition parentTable = null;
    private final List<TableDefinition> childTables = new ArrayList<TableDefinition>();
    private final TableOptions.TableType tableType;
    private final SchemaDefinition referencedSchema;
    private final String referencedName;
    private TableDefinition referencedTable;

    public AbstractTableDefinition(SchemaDefinition schema, String name, String comment) {
        this(schema, name, comment, TableOptions.TableType.TABLE, null);
    }

    public AbstractTableDefinition(SchemaDefinition schema, String name, String comment, TableOptions.TableType tableType, String source) {
        this(schema, name, comment, tableType, source, null, null);
    }

    public AbstractTableDefinition(SchemaDefinition schema, String name, String comment, TableOptions.TableType tableType, String source, SchemaDefinition referencedSchema, String referencedName) {
        super(schema, null, name, comment, source);
        this.tableType = tableType;
        this.referencedSchema = referencedSchema;
        this.referencedName = referencedName;
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    public final List<EmbeddableDefinition> getEmbeddables() {
        return this.getDatabase().getEmbeddables(this);
    }

    @Override
    public final List<EmbeddableDefinition> getReferencedEmbeddables() {
        return this.getDatabase().getEmbeddablesByReferencingTable(this);
    }

    @Override
    public final UniqueKeyDefinition getPrimaryKey() {
        for (ColumnDefinition column : this.getColumns()) {
            if (column.getPrimaryKey() == null) continue;
            return column.getPrimaryKey();
        }
        return null;
    }

    @Override
    public final List<IndexDefinition> getIndexes() {
        return this.getDatabase().getIndexes(this);
    }

    @Override
    public final List<UniqueKeyDefinition> getUniqueKeys() {
        return this.getDatabase().getRelations().getUniqueKeys(this);
    }

    @Override
    public final UniqueKeyDefinition getUniqueKey(String name) {
        for (UniqueKeyDefinition uk : this.getUniqueKeys()) {
            if (!uk.getInputName().equals(name)) continue;
            return uk;
        }
        return null;
    }

    @Override
    public final List<UniqueKeyDefinition> getKeys() {
        return this.getDatabase().getRelations().getKeys(this);
    }

    @Override
    public final UniqueKeyDefinition getKey(String name) {
        for (UniqueKeyDefinition uk : this.getKeys()) {
            if (!uk.getInputName().equals(name)) continue;
            return uk;
        }
        return null;
    }

    @Override
    public final List<ForeignKeyDefinition> getForeignKeys() {
        return this.getDatabase().getRelations().getForeignKeys(this);
    }

    @Override
    public final List<ForeignKeyDefinition> getForeignKeys(TableDefinition referenced) {
        ArrayList<ForeignKeyDefinition> result = new ArrayList<ForeignKeyDefinition>();
        for (ForeignKeyDefinition key : this.getForeignKeys()) {
            if (!referenced.equals(key.getReferencedTable())) continue;
            result.add(key);
        }
        return result;
    }

    @Override
    public final List<InverseForeignKeyDefinition> getInverseForeignKeys() {
        ArrayList<InverseForeignKeyDefinition> result = new ArrayList<InverseForeignKeyDefinition>();
        for (UniqueKeyDefinition uk : this.getKeys()) {
            for (ForeignKeyDefinition fk : uk.getForeignKeys()) {
                result.add(fk.getInverse());
            }
        }
        return result;
    }

    @Override
    public final List<InverseForeignKeyDefinition> getInverseForeignKeys(TableDefinition referencing) {
        ArrayList<InverseForeignKeyDefinition> result = new ArrayList<InverseForeignKeyDefinition>();
        for (InverseForeignKeyDefinition key : this.getInverseForeignKeys()) {
            if (!referencing.equals(key.getReferencingTable())) continue;
            result.add(key);
        }
        return result;
    }

    @Override
    public final List<ManyToManyKeyDefinition> getManyToManyKeys() {
        ArrayList<ManyToManyKeyDefinition> result = new ArrayList<ManyToManyKeyDefinition>();
        for (InverseForeignKeyDefinition k : this.getInverseForeignKeys()) {
            for (UniqueKeyDefinition uk : k.getReferencingTable().getKeys()) {
                if (!uk.getKeyColumns().containsAll(k.getReferencingColumns())) continue;
                block2: for (ForeignKeyDefinition fk : k.getReferencingTable().getForeignKeys()) {
                    if (k.getForeignKey().equals(fk)) continue;
                    HashSet<ColumnDefinition> columns = new HashSet<ColumnDefinition>();
                    columns.addAll(k.getForeignKey().getKeyColumns());
                    for (ColumnDefinition c : fk.getKeyColumns()) {
                        if (columns.add(c)) continue;
                        continue block2;
                    }
                    if (!columns.equals(new HashSet<ColumnDefinition>(uk.getKeyColumns()))) continue;
                    result.add(new DefaultManyToManyKeyDefinition(k.getForeignKey(), uk, fk));
                }
            }
        }
        return result;
    }

    @Override
    public final List<ManyToManyKeyDefinition> getManyToManyKeys(TableDefinition referencing) {
        ArrayList<ManyToManyKeyDefinition> result = new ArrayList<ManyToManyKeyDefinition>();
        for (ManyToManyKeyDefinition key : this.getManyToManyKeys()) {
            if (!referencing.equals(key.getForeignKey2().getReferencedTable())) continue;
            result.add(key);
        }
        return result;
    }

    @Override
    public final List<CheckConstraintDefinition> getCheckConstraints() {
        return this.getDatabase().getRelations().getCheckConstraints(this);
    }

    @Override
    public final IdentityDefinition getIdentity() {
        for (ColumnDefinition column : this.getColumns()) {
            if (!column.isIdentity()) continue;
            return new DefaultIdentityDefinition(column);
        }
        return null;
    }

    public final void setParentTable(TableDefinition parentTable) {
        this.parentTable = parentTable;
    }

    @Override
    public final TableDefinition getParentTable() {
        return this.parentTable;
    }

    @Override
    public final List<TableDefinition> getChildTables() {
        return this.childTables;
    }

    @Override
    public final Table<Record> getTable() {
        return new TableImpl(this.getQualifiedNamePart(), null, null, null, DSL.comment((String)this.getComment()), this.getTableOptions());
    }

    @Override
    public final TableOptions getTableOptions() {
        if (this.isTableValuedFunction()) {
            return TableOptions.function((String)this.getSource());
        }
        if (this.isMaterializedView()) {
            return TableOptions.materializedView((String)this.getSource());
        }
        if (this.isView()) {
            return TableOptions.view((String)this.getSource());
        }
        if (this.isTemporary()) {
            return TableOptions.temporaryTable();
        }
        return TableOptions.table();
    }

    @Override
    public final List<ColumnDefinition> getColumns() {
        return this.getElements();
    }

    @Override
    public final ColumnDefinition getColumn(String columnName) {
        return (ColumnDefinition)this.getElement(columnName);
    }

    @Override
    public final ColumnDefinition getColumn(String columnName, boolean ignoreCase) {
        return (ColumnDefinition)this.getElement(columnName, ignoreCase);
    }

    @Override
    public final ColumnDefinition getColumn(int columnIndex) {
        return (ColumnDefinition)this.getElement(columnIndex);
    }

    @Override
    public final List<ParameterDefinition> getParameters() {
        if (this.parameters == null) {
            this.parameters = this.getParameters0();
        }
        return this.parameters;
    }

    @Override
    public final boolean isTemporary() {
        return this.tableType == TableOptions.TableType.TEMPORARY;
    }

    @Override
    public final boolean isView() {
        return this.tableType == TableOptions.TableType.VIEW;
    }

    @Override
    public final boolean isMaterializedView() {
        return this.tableType == TableOptions.TableType.MATERIALIZED_VIEW;
    }

    @Override
    public final boolean isTableValuedFunction() {
        return this.tableType == TableOptions.TableType.FUNCTION;
    }

    @Override
    public final TableDefinition getReferencedTable() {
        if (this.referencedTable == null) {
            if (this.referencedSchema != null) {
                this.referencedTable = this.getDatabase().getTable(this.referencedSchema, this.referencedName);
            }
            if (this.referencedTable == null) {
                this.referencedTable = this;
            }
        }
        return this.referencedTable;
    }

    @Override
    protected List<ColumnDefinition> getElements0() throws SQLException {
        return null;
    }

    protected List<ParameterDefinition> getParameters0() {
        return Collections.emptyList();
    }
}

