/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.mysql;

import java.util.Arrays;
import java.util.regex.Matcher;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.TableLike;
import org.jooq.meta.AbstractRoutineDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultParameterDefinition;
import org.jooq.meta.InOutDefinition;
import org.jooq.meta.ParameterDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.mysql.MySQLDatabase;
import org.jooq.meta.mysql.information_schema.Tables;
import org.jooq.meta.mysql.mysql.enums.ProcType;
import org.jooq.tools.StringUtils;

public class MySQLRoutineDefinition
extends AbstractRoutineDefinition {
    private final String params;
    private final String returns;
    private final ProcType procType;

    @Deprecated
    public MySQLRoutineDefinition(SchemaDefinition schema, String name, String comment, String params, String returns) {
        this(schema, name, comment, params, returns, null, null);
    }

    public MySQLRoutineDefinition(SchemaDefinition schema, String name, String comment, String params, String returns, ProcType procType, String overload) {
        super(schema, null, name, comment, overload);
        this.params = params;
        this.returns = returns;
        this.procType = procType;
    }

    @Override
    protected void init0() {
        if (((MySQLDatabase)this.getDatabase()).is5_5()) {
            this.init55();
        } else {
            this.init54();
        }
    }

    private void init55() {
        for (Record record : this.create().select(Tables.PARAMETERS.ORDINAL_POSITION, Tables.PARAMETERS.PARAMETER_NAME, Tables.PARAMETERS.PARAMETER_MODE, Tables.PARAMETERS.DATA_TYPE, Tables.PARAMETERS.DTD_IDENTIFIER, Tables.PARAMETERS.CHARACTER_MAXIMUM_LENGTH, Tables.PARAMETERS.NUMERIC_PRECISION, Tables.PARAMETERS.NUMERIC_SCALE).from((TableLike)Tables.PARAMETERS).where(Tables.PARAMETERS.SPECIFIC_SCHEMA.in((Object[])new String[]{this.getSchema().getInputName(), this.getSchema().getInputName()})).and(Tables.PARAMETERS.SPECIFIC_NAME.eq((Object)this.getInputName())).and(Tables.PARAMETERS.ROUTINE_TYPE.eq((Object)this.procType.name())).orderBy((OrderField)Tables.PARAMETERS.ORDINAL_POSITION.asc()).fetch()) {
            String inOut = (String)record.get(Tables.PARAMETERS.PARAMETER_MODE);
            Object dataType = (String)record.get(Tables.PARAMETERS.DATA_TYPE);
            if (this.getDatabase().supportsUnsignedTypes() && Arrays.asList("tinyint", "smallint", "mediumint", "int", "bigint").contains(((String)dataType).toLowerCase()) && ((String)record.get(Tables.PARAMETERS.DTD_IDENTIFIER)).toLowerCase().contains("unsigned")) {
                dataType = (String)dataType + "unsigned";
            }
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), (String)dataType, (Number)record.get(Tables.PARAMETERS.CHARACTER_MAXIMUM_LENGTH), (Number)record.get(Tables.PARAMETERS.NUMERIC_PRECISION), (Number)record.get(Tables.PARAMETERS.NUMERIC_SCALE), null, null);
            if (inOut == null) {
                this.addParameter(InOutDefinition.RETURN, new DefaultParameterDefinition(this, "RETURN_VALUE", -1, type));
                continue;
            }
            DefaultParameterDefinition parameter = new DefaultParameterDefinition(this, ((String)record.get(Tables.PARAMETERS.PARAMETER_NAME)).replaceAll("@", ""), (Integer)record.get(Tables.PARAMETERS.ORDINAL_POSITION, Integer.TYPE), type);
            this.addParameter(InOutDefinition.getFromString(inOut), parameter);
        }
    }

    private void init54() {
        String[] split = this.params.split(",(?!\\s*\\d+\\s*\\))");
        Matcher matcher = TYPE_PATTERN.matcher(this.returns);
        if (matcher.find()) {
            this.addParameter(InOutDefinition.RETURN, this.createParameter(matcher, 0, -1, "RETURN_VALUE"));
        }
        for (int i = 0; i < split.length; ++i) {
            String param = split[i];
            param = param.trim();
            matcher = PARAMETER_PATTERN.matcher(param);
            while (matcher.find()) {
                InOutDefinition inOut = InOutDefinition.getFromString(matcher.group(2));
                this.addParameter(inOut, this.createParameter(matcher, 3, i + 1));
            }
        }
    }

    private ParameterDefinition createParameter(Matcher matcher, int group, int columnIndex) {
        return this.createParameter(matcher, group, columnIndex, matcher.group(group));
    }

    private ParameterDefinition createParameter(Matcher matcher, int group, int columnIndex, String paramName) {
        String paramType = matcher.group(group + 1);
        Integer precision = 0;
        Integer scale = 0;
        if (!StringUtils.isBlank((String)matcher.group(group + 2))) {
            precision = Integer.valueOf(matcher.group(group + 2));
        }
        if (!StringUtils.isBlank((String)matcher.group(group + 3))) {
            scale = Integer.valueOf(matcher.group(group + 3));
        }
        DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), paramType, precision, precision, scale, null, null);
        return new DefaultParameterDefinition(this, paramName, columnIndex, type);
    }
}

