/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jooq.meta.jaxb.RegexFlag;

public final class Patterns {
    private final Map<String, Pattern> patterns = new HashMap<String, Pattern>();
    private List<RegexFlag> regexFlags;

    public final Pattern pattern(String regex) {
        if (regex == null) {
            return null;
        }
        Pattern pattern = this.patterns.get(regex);
        if (pattern == null) {
            int flags = 0;
            ArrayList<RegexFlag> list = new ArrayList<RegexFlag>(this.getRegexFlags());
            if (list.isEmpty()) {
                list.add(RegexFlag.COMMENTS);
                list.add(RegexFlag.CASE_INSENSITIVE);
            }
            for (RegexFlag flag : list) {
                switch (flag) {
                    case CANON_EQ: {
                        flags |= 0x80;
                        break;
                    }
                    case CASE_INSENSITIVE: {
                        flags |= 2;
                        break;
                    }
                    case COMMENTS: {
                        flags |= 4;
                        break;
                    }
                    case DOTALL: {
                        flags |= 0x20;
                        break;
                    }
                    case LITERAL: {
                        flags |= 0x10;
                        break;
                    }
                    case MULTILINE: {
                        flags |= 8;
                        break;
                    }
                    case UNICODE_CASE: {
                        flags |= 0x40;
                        break;
                    }
                    case UNICODE_CHARACTER_CLASS: {
                        flags |= 0x100;
                        break;
                    }
                    case UNIX_LINES: {
                        flags |= 1;
                    }
                }
            }
            pattern = Pattern.compile(regex, flags);
            this.patterns.put(regex, pattern);
        }
        return pattern;
    }

    public void setRegexFlags(List<RegexFlag> regexFlags) {
        this.regexFlags = regexFlags;
        this.patterns.clear();
    }

    public List<RegexFlag> getRegexFlags() {
        if (this.regexFlags == null) {
            this.regexFlags = new ArrayList<RegexFlag>();
        }
        return this.regexFlags;
    }
}

