/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.AbstractTypedElementDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.EmbeddableDefinition;
import org.jooq.meta.ForeignKeyDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UniqueKeyDefinition;
import org.jooq.meta.jaxb.SyntheticIdentityType;
import org.jooq.tools.JooqLogger;

public class DefaultColumnDefinition
extends AbstractTypedElementDefinition<TableDefinition>
implements ColumnDefinition {
    private static final JooqLogger log = JooqLogger.getLogger(DefaultColumnDefinition.class);
    private final int position;
    private final boolean identity;
    private final boolean readonly;
    private transient List<EmbeddableDefinition> replacedByEmbeddables;
    private boolean synthetic;

    public DefaultColumnDefinition(TableDefinition table, String name, int position, DataTypeDefinition type, boolean identity, String comment) {
        this(table, name, position, type, identity, false, comment);
    }

    public DefaultColumnDefinition(TableDefinition table, String name, int position, DataTypeDefinition type, boolean identity, boolean readonly, String comment) {
        super(table, name, position, type, comment);
        this.position = position;
        this.identity = identity || DefaultColumnDefinition.isSyntheticIdentity(this);
        boolean bl = this.readonly = readonly || DefaultColumnDefinition.isSyntheticReadonlyColumn(this, this.identity);
        if (type instanceof DefaultDataTypeDefinition) {
            DefaultDataTypeDefinition dd = (DefaultDataTypeDefinition)type;
            dd.identity(this.identity);
            dd.readonly(this.readonly);
        }
    }

    private static boolean isSyntheticIdentity(DefaultColumnDefinition column) {
        AbstractDatabase db = (AbstractDatabase)column.getDatabase();
        for (SyntheticIdentityType id : db.getConfiguredSyntheticIdentities()) {
            for (TableDefinition t : db.filter(Collections.singletonList((TableDefinition)column.getContainer()), id.getTables())) {
                Iterator<DefaultColumnDefinition> iterator = db.filter(Collections.singletonList(column), id.getFields()).iterator();
                if (!iterator.hasNext()) continue;
                ColumnDefinition c = iterator.next();
                log.info((Object)"Synthetic identity", (Object)column.getQualifiedName());
                db.markUsed(id);
                return true;
            }
        }
        return false;
    }

    private static boolean isSyntheticReadonlyColumn(DefaultColumnDefinition column, boolean identity) {
        return false;
    }

    final DefaultColumnDefinition synthetic(boolean s) {
        this.synthetic = s;
        return this;
    }

    @Override
    public final boolean isSynthetic() {
        return this.synthetic;
    }

    @Override
    public final int getPosition() {
        return this.position;
    }

    @Override
    public final UniqueKeyDefinition getPrimaryKey() {
        return this.getDatabase().getRelations().getPrimaryKey(this);
    }

    @Override
    public final List<UniqueKeyDefinition> getUniqueKeys() {
        return this.getDatabase().getRelations().getUniqueKeys(this);
    }

    @Override
    public final List<UniqueKeyDefinition> getKeys() {
        return this.getDatabase().getRelations().getKeys(this);
    }

    @Override
    public final List<ForeignKeyDefinition> getForeignKeys() {
        return this.getDatabase().getRelations().getForeignKeys(this);
    }

    @Override
    public final boolean isIdentity() {
        return this.identity;
    }

    @Override
    public final boolean isReadonly() {
        return this.readonly;
    }
}

