/*
 * Decompiled with CFR 0.152.
 */
package org.joox;

import jakarta.xml.bind.DataBindingException;
import jakarta.xml.bind.JAXB;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.joox.Content;
import org.joox.Context;
import org.joox.Each;
import org.joox.Elements;
import org.joox.FastFilter;
import org.joox.Filter;
import org.joox.Impl;
import org.joox.Mapper;
import org.joox.Match;
import org.joox.Util;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class JOOX {
    private static final Set<String> TRUE_VALUES = new HashSet<String>();
    private static final Set<String> FALSE_VALUES = new HashSet<String>();
    private static final FastFilter NONE;
    private static final FastFilter ALL;
    private static final FastFilter EVEN;
    private static final FastFilter ODD;
    private static final FastFilter LEAF;

    public static Match $() {
        return JOOX.$(JOOX.builder().newDocument());
    }

    public static Match $(Object object) {
        Document document = JOOX.builder().newDocument();
        if (object != null) {
            DOMResult result = new DOMResult(document);
            JAXB.marshal((Object)object, (Result)result);
        }
        return JOOX.$(document);
    }

    public static Match $(String name) {
        Document document = JOOX.builder().newDocument();
        DocumentFragment fragment = Util.createContent(document, name, true);
        if (fragment != null) {
            NodeList children = fragment.getChildNodes();
            int i = 0;
            block3: while (i < children.getLength()) {
                Node node = children.item(i);
                switch (node.getNodeType()) {
                    case 3: 
                    case 4: {
                        ++i;
                        continue block3;
                    }
                }
                document.appendChild(node);
            }
        } else {
            document.appendChild(document.createElement(name));
        }
        return JOOX.$(document);
    }

    public static Match $(String name, String content) {
        return JOOX.$(name).append(content);
    }

    public static Match $(String name, Element ... content) {
        return JOOX.$(name).append(content);
    }

    public static Match $(String name, Match ... content) {
        return JOOX.$(name).append(content);
    }

    public static Match $(Document document) {
        if (document == null) {
            return JOOX.$();
        }
        if (document.getDocumentElement() == null) {
            return new Impl(document, null);
        }
        return JOOX.$(document.getDocumentElement());
    }

    public static Match $(Element element) {
        if (element == null) {
            return JOOX.$();
        }
        return new Impl(element.getOwnerDocument(), null).addElements(element);
    }

    public static Match $(Node node) {
        if (node instanceof Document) {
            return JOOX.$((Document)node);
        }
        if (node instanceof Element) {
            return JOOX.$((Element)node);
        }
        return JOOX.$();
    }

    public static Match $(NodeList list) {
        if (list != null && list.getLength() > 0) {
            return new Impl(list.item(0).getOwnerDocument(), null).addNodeList(list);
        }
        return JOOX.$();
    }

    public static Match $(Context context) {
        if (context == null) {
            return JOOX.$();
        }
        return JOOX.$(context.element());
    }

    public static Match $(Match match) {
        if (match == null) {
            return JOOX.$();
        }
        return match;
    }

    public static Match $(URL url) throws SAXException, IOException {
        return JOOX.$(url.openStream());
    }

    public static Match $(URI uri) throws SAXException, IOException {
        return JOOX.$(new File(uri));
    }

    public static Match $(File file) throws SAXException, IOException {
        return JOOX.$(JOOX.builder().parse(file));
    }

    public static Match $(Path path) throws SAXException, IOException {
        return JOOX.$(path.toFile());
    }

    public static Match $(InputStream stream) throws SAXException, IOException {
        return JOOX.$(JOOX.builder().parse(stream));
    }

    public static Match $(Reader reader) throws SAXException, IOException {
        return JOOX.$(JOOX.builder().parse(new InputSource(reader)));
    }

    public static Match $(InputSource source) throws SAXException, IOException {
        return JOOX.$(JOOX.builder().parse(source));
    }

    public static FastFilter none() {
        return NONE;
    }

    public static FastFilter all() {
        return ALL;
    }

    public static FastFilter even() {
        return EVEN;
    }

    public static FastFilter odd() {
        return ODD;
    }

    public static FastFilter leaf() {
        return LEAF;
    }

    public static FastFilter at(int ... indexes) {
        return context -> {
            for (int i : indexes) {
                if (i != context.elementIndex()) continue;
                return true;
            }
            return false;
        };
    }

    public static Filter selector(String selector) {
        return JOOX.tag(selector);
    }

    public static FastFilter tag(String tagName) {
        return JOOX.tag(tagName, true);
    }

    public static FastFilter tag(String tagName, boolean ignoreNamespace) {
        if (tagName == null || tagName.equals("")) {
            return JOOX.none();
        }
        if ("*".equals(tagName)) {
            return JOOX.all();
        }
        return context -> {
            String localName = context.element().getTagName();
            if (ignoreNamespace) {
                localName = Util.stripNamespace(localName);
            }
            return tagName.equals(localName);
        };
    }

    public static FastFilter namespacePrefix(String namespacePrefix) {
        if ("*".equals(namespacePrefix)) {
            return JOOX.all();
        }
        return context -> {
            String match = JOOX.$(context).namespacePrefix();
            if (match == null || "".equals(match)) {
                return namespacePrefix == null || "".equals(namespacePrefix);
            }
            return match.equals(namespacePrefix);
        };
    }

    public static FastFilter namespaceURI(String namespaceURI) {
        if ("*".equals(namespaceURI)) {
            return JOOX.all();
        }
        return context -> {
            String match = JOOX.$(context).namespaceURI();
            if (match == null || "".equals(match)) {
                return namespaceURI == null || "".equals(namespaceURI);
            }
            return match.equals(namespaceURI);
        };
    }

    public static FastFilter matchText(String regex) {
        if (regex == null || regex.equals("")) {
            return JOOX.none();
        }
        Pattern pattern = Pattern.compile(regex);
        return context -> pattern.matcher(JOOX.$(context).text()).matches();
    }

    public static FastFilter matchAttr(String name, String valueRegex) {
        if (name == null || name.equals("") || valueRegex == null || valueRegex.equals("")) {
            return JOOX.none();
        }
        Pattern pattern = Pattern.compile(valueRegex);
        return context -> {
            String value = JOOX.$(context).attr(name);
            if (value == null) {
                return false;
            }
            return pattern.matcher(value).matches();
        };
    }

    public static FastFilter matchTag(String regex) {
        return JOOX.matchTag(regex, true);
    }

    public static FastFilter matchTag(String regex, boolean ignoreNamespace) {
        if (regex == null || regex.equals("")) {
            return JOOX.none();
        }
        Pattern pattern = Pattern.compile(regex);
        return context -> {
            String localName = context.element().getTagName();
            if (ignoreNamespace) {
                localName = Util.stripNamespace(localName);
            }
            return pattern.matcher(localName).matches();
        };
    }

    public static FastFilter attr(String name) {
        if (name == null || name.equals("")) {
            return context -> context.element().getAttributes().getLength() == 0;
        }
        return context -> JOOX.$(context).attr(name) != null;
    }

    public static FastFilter attr(String name, String value) {
        if (name == null || name.equals("")) {
            return JOOX.attr(name);
        }
        return context -> Objects.equals(JOOX.$(context).attr(name), value);
    }

    public static FastFilter attr(String name, String ... values) {
        List<String> list = Arrays.asList(values);
        if (name == null || name.equals("")) {
            return JOOX.attr(name);
        }
        return context -> list.contains(JOOX.$(context).attr(name));
    }

    public static Filter and(Filter ... filters) {
        return context -> {
            for (Filter filter : filters) {
                if (filter.filter(context)) continue;
                return false;
            }
            return true;
        };
    }

    public static Filter or(Filter ... filters) {
        return context -> {
            for (Filter filter : filters) {
                if (!filter.filter(context)) continue;
                return true;
            }
            return false;
        };
    }

    public static Filter not(Filter filter) {
        return context -> !filter.filter(context);
    }

    public static FastFilter ids(String ... ids) {
        HashSet<String> set = new HashSet<String>(Arrays.asList(ids));
        return context -> set.contains(JOOX.$(context).attr("id"));
    }

    public static Content content(String value) {
        return context -> value;
    }

    public static Content content(final Object value) {
        if (value == null) {
            return JOOX.content("");
        }
        return new Content(){
            private String marshalled;

            @Override
            public String content(Context context) {
                if (this.marshalled == null) {
                    try {
                        JAXBContext jaxb = JAXBContext.newInstance((Class[])new Class[]{value.getClass()});
                        Marshaller marshaller = jaxb.createMarshaller();
                        marshaller.setProperty("jaxb.fragment", (Object)true);
                        StringWriter writer = new StringWriter();
                        marshaller.marshal(value, (Writer)writer);
                        this.marshalled = writer.toString();
                    }
                    catch (JAXBException e) {
                        throw new DataBindingException((Throwable)e);
                    }
                }
                return this.marshalled;
            }
        };
    }

    public static Mapper<String> ids() {
        return JOOX.attrs("id");
    }

    public static Mapper<String> attrs(String attributeName) {
        return context -> JOOX.$(context).attr(attributeName);
    }

    public static Mapper<String> paths() {
        return context -> Util.path(context.element());
    }

    public static Each chain(Each ... each) {
        return JOOX.chain(Arrays.asList(each));
    }

    public static Each chain(Iterable<? extends Each> each) {
        return context -> {
            if (each != null) {
                for (Each e : each) {
                    e.each(context);
                }
            }
        };
    }

    public static Iterable<Element> iterable(NodeList elements) {
        return new Elements(elements);
    }

    public static Iterator<Element> iterator(NodeList elements) {
        return new Elements(elements).iterator();
    }

    public static List<Element> list(NodeList elements) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (Element element : JOOX.iterable(elements)) {
            list.add(element);
        }
        return list;
    }

    public static DocumentBuilder builder() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            try {
                factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            try {
                factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            try {
                factory.setXIncludeAware(false);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            factory.setExpandEntityReferences(false);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T convert(String value, Class<T> type) {
        if (value == null && type.isPrimitive()) {
            value = "0";
        }
        if (value == null) {
            return null;
        }
        if (type.isArray()) {
            Class<?> component = type.getComponentType();
            List<String> split = Util.split(value);
            return (T)JOOX.convert(split, component).toArray((Object[])Array.newInstance(component, split.size()));
        }
        if (type == String.class) {
            return (T)value;
        }
        if (type == Object.class) {
            return (T)value;
        }
        if (type == Byte.class || type == Byte.TYPE) {
            try {
                return (T)Byte.valueOf(new BigDecimal(value).byteValue());
            }
            catch (Exception e) {
                return (T)(type == Byte.class ? null : Byte.valueOf((byte)0));
            }
        }
        if (type == Short.class || type == Short.TYPE) {
            try {
                return (T)Short.valueOf(new BigDecimal(value).shortValue());
            }
            catch (Exception e) {
                return (T)(type == Short.class ? null : Short.valueOf((short)0));
            }
        }
        if (type == Integer.class || type == Integer.TYPE) {
            try {
                return (T)Integer.valueOf(new BigDecimal(value).intValue());
            }
            catch (Exception e) {
                return (T)(type == Integer.class ? null : Integer.valueOf(0));
            }
        }
        if (type == Long.class || type == Long.TYPE) {
            try {
                return (T)Long.valueOf(new BigDecimal(value).longValue());
            }
            catch (Exception e) {
                return (T)(type == Long.class ? null : Long.valueOf(0L));
            }
        }
        if (type == Float.class || type == Float.TYPE) {
            try {
                return (T)Float.valueOf(value);
            }
            catch (Exception e) {
                return (T)(type == Float.class ? null : Float.valueOf(0.0f));
            }
        }
        if (type == Double.class || type == Double.TYPE) {
            try {
                return (T)Double.valueOf(value);
            }
            catch (Exception e) {
                return (T)(type == Double.class ? null : Double.valueOf(0.0));
            }
        }
        if (type == BigDecimal.class) {
            try {
                return (T)new BigDecimal(value);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (type == BigInteger.class) {
            try {
                return (T)new BigDecimal(value).toBigInteger();
            }
            catch (Exception e) {
                return null;
            }
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            String s = value.toLowerCase();
            if (TRUE_VALUES.contains(s)) {
                return (T)Boolean.TRUE;
            }
            if (FALSE_VALUES.contains(s)) {
                return (T)Boolean.FALSE;
            }
            return (T)(type == Boolean.class ? null : Boolean.valueOf(false));
        }
        if (type == java.util.Date.class) {
            try {
                return (T)Util.parseDate(value);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (type == Calendar.class) {
            try {
                Calendar cal = Calendar.getInstance();
                cal.setTime(Util.parseDate(value));
                return (T)cal;
            }
            catch (Exception e) {
                return null;
            }
        }
        if (type == GregorianCalendar.class) {
            try {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(Util.parseDate(value));
                return (T)cal;
            }
            catch (Exception e) {
                return null;
            }
        }
        if (type == Timestamp.class) {
            try {
                return (T)new Timestamp(Util.parseDate(value).getTime());
            }
            catch (Exception e) {
                return null;
            }
        }
        if (type == Date.class) {
            try {
                return (T)new Date(Util.parseDate(value).getTime());
            }
            catch (Exception e) {
                return null;
            }
        }
        if (type == Time.class) {
            try {
                return (T)new Time(Util.parseDate(value).getTime());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static <T> List<T> convert(List<String> values, Class<T> type) {
        ArrayList<T> result = new ArrayList<T>();
        for (String value : values) {
            result.add(JOOX.convert(value, type));
        }
        return result;
    }

    static {
        TRUE_VALUES.add("1");
        TRUE_VALUES.add("y");
        TRUE_VALUES.add("yes");
        TRUE_VALUES.add("true");
        TRUE_VALUES.add("on");
        TRUE_VALUES.add("enabled");
        FALSE_VALUES.add("0");
        FALSE_VALUES.add("n");
        FALSE_VALUES.add("no");
        FALSE_VALUES.add("false");
        FALSE_VALUES.add("off");
        FALSE_VALUES.add("disabled");
        NONE = context -> false;
        ALL = context -> true;
        EVEN = context -> context.elementIndex() % 2 == 0;
        ODD = context -> context.elementIndex() % 2 != 0;
        LEAF = context -> {
            NodeList children = context.element().getChildNodes();
            int i = 0;
            Node item;
            while ((item = children.item(i)) != null) {
                if (item.getNodeType() == 1) {
                    return false;
                }
                ++i;
            }
            return true;
        };
    }
}

