/*
 * Decompiled with CFR 0.152.
 */
package org.josso.agent.http;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.agent.Lookup;
import org.josso.agent.http.HttpSSOAgent;
import org.josso.agent.http.JOSSOSecurityContext;

public class WebAccessControlUtil {
    public static final Log log = LogFactory.getLog(WebAccessControlUtil.class);
    public static final String KEY_JOSSO_SAVED_REQUEST_URI = "JOSSO_SAVED_REQUEST";
    public static final String KEY_JOSSO_SECURITY_CONTEXT = "org.josso.servlet.agent.JOSSOSecurityContext";

    public static void askForLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        StringBuffer sb = new StringBuffer(request.getRequestURI());
        if (request.getQueryString() != null) {
            sb.append('?');
            sb.append(request.getQueryString());
        }
        HttpSSOAgent agent = (HttpSSOAgent)Lookup.getInstance().lookupSSOAgent();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Storing original request : " + sb.toString()));
        }
        agent.setAttribute(request, response, KEY_JOSSO_SAVED_REQUEST_URI, sb.toString());
        response.sendRedirect(request.getContextPath() + agent.getJossoLoginUri());
    }

    public static JOSSOSecurityContext getSecurityContext(HttpServletRequest request) {
        return (JOSSOSecurityContext)request.getSession().getAttribute(KEY_JOSSO_SECURITY_CONTEXT);
    }
}

