/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.ldap;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.jboss.logging.Logger;
import org.jboss.portal.common.util.Tools;
import org.jboss.portal.identity.CachedUserImpl;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.NoSuchUserException;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.ldap.LDAPMembershipModule;
import org.jboss.portal.identity.ldap.LDAPRoleImpl;
import org.jboss.portal.identity.ldap.LDAPUserImpl;

public class LDAPStaticRoleMembershipModuleImpl
extends LDAPMembershipModule {
    private static final Logger log = Logger.getLogger(LDAPStaticRoleMembershipModuleImpl.class);

    public Set getRoles(User user) throws IdentityException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user instanceof CachedUserImpl) {
            try {
                user = this.getUserModule().findUserById(user.getId());
            }
            catch (NoSuchUserException e) {
                throw new IdentityException("Illegal state - cached user doesn't exist in identity store: ", e);
            }
        }
        LDAPUserImpl ldapUser = null;
        if (!(user instanceof LDAPUserImpl)) {
            throw new IllegalArgumentException("UserMembershipModuleImpl supports only LDAPUserImpl objects");
        }
        ldapUser = (LDAPUserImpl)user;
        HashSet<Role> roles = new HashSet<Role>();
        LdapContext ldapContext = this.getConnectionContext().createInitialContext();
        try {
            log.debug((Object)("findRoles(): role = " + ldapUser.getDn()));
            if (ldapUser.getUserName() == null) {
                throw new IdentityException("Role name canot be null");
            }
            Attributes attrs = ldapContext.getAttributes(ldapUser.getDn());
            if (attrs == null) {
                throw new IdentityException("Cannot find User with DN: " + ldapUser.getDn());
            }
            Attribute memberOfAttribute = attrs.get(this.getMemberAttributeID());
            if (memberOfAttribute == null) {
                HashSet<Role> hashSet = roles;
                return hashSet;
            }
            NamingEnumeration<?> values = memberOfAttribute.getAll();
            while (values.hasMoreElements()) {
                String value;
                String name = value = values.nextElement().toString();
                try {
                    if (this.isUidAttributeIsDN()) {
                        roles.add(this.getRoleModule().findRoleByDN(name));
                        continue;
                    }
                    roles.add(this.getRoleModule().findRoleByName(name));
                }
                catch (IdentityException ie) {
                    log.error((Object)("Failed to find role: " + name + "/" + value), (Throwable)ie);
                }
            }
        }
        catch (NamingException e) {
            throw new IdentityException("Resolving User Roles failed.", e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
        return roles;
    }

    public Set getUsers(Role role) throws IdentityException {
        return this.getUsers(role, null);
    }

    public Set getUsers(Role role, String userNameFilter) throws IdentityException {
        if (role == null) {
            throw new IllegalArgumentException("Role cannot be null");
        }
        LDAPRoleImpl ldapRole = null;
        if (!(role instanceof LDAPRoleImpl)) {
            throw new IllegalArgumentException("UserMembershipModuleImpl supports only LDAPRoleImpl objects");
        }
        ldapRole = (LDAPRoleImpl)role;
        HashSet<LDAPUserImpl> users = new HashSet<LDAPUserImpl>();
        try {
            log.debug((Object)("getUsers(): role DN = " + ldapRole.getDn()));
            String memberOfName = "";
            memberOfName = this.isUidAttributeIsDN() ? ldapRole.getDn() : ldapRole.getName();
            String filter = this.getMemberAttributeID().concat("=").concat(memberOfName);
            log.debug((Object)("Search filter: " + filter));
            List sr = this.getUserModule().searchUsers(filter, null);
            for (SearchResult res : sr) {
                DirContext ctx = (DirContext)res.getObject();
                LDAPUserImpl user = this.getUserModule().createUserInstance(res.getAttributes(), ctx.getNameInNamespace());
                if (userNameFilter != null && userNameFilter.length() != 0 && !user.getUserName().matches(".*" + userNameFilter + ".*")) continue;
                users.add(user);
            }
        }
        catch (Exception e) {
            log.debug((Object)("Failed to resolve role users: " + ldapRole.getId().toString()), (Throwable)e);
        }
        return users;
    }

    public void assignUsers(Role role, Set users) throws IdentityException {
        if (role == null) {
            throw new IllegalArgumentException("Role cannot be null");
        }
        LDAPRoleImpl ldapRole = null;
        if (!(role instanceof LDAPRoleImpl)) {
            throw new IllegalArgumentException("UserMembershipModuleImpl supports only LDAPRoleImpl objects");
        }
        ldapRole = (LDAPRoleImpl)role;
        LinkedList<String> userDNsToAdd = new LinkedList<String>();
        Iterator iterator = users.iterator();
        while (iterator.hasNext()) {
            try {
                User user = (User)iterator.next();
                if (user instanceof CachedUserImpl) {
                    try {
                        user = this.getUserModule().findUserById(user.getId());
                    }
                    catch (NoSuchUserException e) {
                        throw new IdentityException("Illegal state - cached user doesn't exist in identity store: ", e);
                    }
                }
                LDAPUserImpl ldapUser = (LDAPUserImpl)user;
                userDNsToAdd.add(ldapUser.getDn());
            }
            catch (ClassCastException e) {
                throw new IdentityException("Can add only LDAPUserImpl objects", e);
            }
        }
        String memberOfName = null;
        memberOfName = this.isUidAttributeIsDN() ? ldapRole.getDn() : ldapRole.getName();
        LdapContext ldapContext = this.getConnectionContext().createInitialContext();
        try {
            String filter = this.getMemberAttributeID().concat("=").concat(memberOfName);
            log.debug((Object)("Search filter: " + filter));
            List sr = this.getUserModule().searchUsers(filter, null);
            for (SearchResult res : sr) {
                DirContext ctx = (DirContext)res.getObject();
                String userDN = ctx.getNameInNamespace();
                if (userDNsToAdd.contains(userDN)) {
                    userDNsToAdd.remove(userDN);
                    continue;
                }
                Attribute attr = res.getAttributes().get(this.getMemberAttributeID());
                attr.remove(memberOfName);
                BasicAttributes newAttrs = new BasicAttributes(true);
                newAttrs.put(attr);
                ldapContext.modifyAttributes(userDN, 2, (Attributes)newAttrs);
                userDNsToAdd.remove(userDN);
            }
            for (String userDN : userDNsToAdd) {
                ModificationItem[] mods = new ModificationItem[]{new ModificationItem(1, new BasicAttribute(this.getMemberAttributeID(), memberOfName))};
                ldapContext.modifyAttributes(userDN, mods);
            }
            this.fireMembershipChangedEvent(role, users);
        }
        catch (NamingException e) {
            throw new IdentityException("Failed to assign users", e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
    }

    public void assignRoles(User user, Set roles) throws IdentityException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user instanceof CachedUserImpl) {
            try {
                user = this.getUserModule().findUserById(user.getId());
            }
            catch (NoSuchUserException e) {
                throw new IdentityException("Illegal state - cached user doesn't exist in identity store: ", e);
            }
        }
        LDAPUserImpl ldapUser = null;
        if (!(user instanceof LDAPUserImpl)) {
            throw new IllegalArgumentException("UserMembershipModuleImpl supports only LDAPUserImpl objects");
        }
        ldapUser = (LDAPUserImpl)user;
        LdapContext ldapContext = this.getConnectionContext().createInitialContext();
        try {
            log.debug((Object)("findRoles(): user = " + ldapUser.getDn()));
            if (ldapUser.getUserName() == null) {
                throw new IdentityException("User name canot be null");
            }
            BasicAttributes attrs = new BasicAttributes(true);
            BasicAttribute member = new BasicAttribute(this.getMemberAttributeID());
            Iterator iterator = roles.iterator();
            while (iterator.hasNext()) {
                try {
                    LDAPRoleImpl role = (LDAPRoleImpl)iterator.next();
                    if (this.isUidAttributeIsDN()) {
                        member.add(role.getDn());
                        continue;
                    }
                    member.add(role.getName());
                }
                catch (ClassCastException e) {
                    throw new IdentityException("Only can add LDAPRoleImpl objects", e);
                }
            }
            attrs.put(member);
            ldapContext.modifyAttributes(ldapUser.getDn(), 2, (Attributes)attrs);
            this.fireMembershipChangedEvent(user, roles);
        }
        catch (NamingException e) {
            throw new IdentityException("Failed to change Role members", e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
    }

    public Set findRoleMembers(String roleName, int offset, int limit, String userNameFilter) throws IdentityException {
        Role role = this.getRoleModule().findRoleByName(roleName);
        if (role != null) {
            Set users = this.getUsers(role, userNameFilter);
            int size = users.size();
            if (offset == 0 && size <= limit) {
                return users;
            }
            Collections.sort(Tools.toList(users.iterator()), new LDAPUserImpl.LDAPUserComparator());
            if (offset + limit <= size) {
                return Tools.toSet(Tools.toList(users.iterator()).subList(offset, offset + limit).iterator());
            }
            if (offset >= size) {
                return new HashSet();
            }
            return Tools.toSet(Tools.toList(users.iterator()).subList(offset, size).iterator());
        }
        throw new IdentityException("Role not found with roleName: " + roleName);
    }
}

