/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.metadata.service;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.metadata.config.ConfigOptionMetaData;
import org.jboss.portal.identity.metadata.config.DatasourceMetaData;
import org.jboss.portal.identity.metadata.config.DatasourcesMetaData;
import org.jboss.portal.identity.metadata.config.IdentityMetadataProcessor;
import org.jboss.portal.identity.metadata.service.DatasourceServiceMetaData;

public class DatasourceServicesMetaData {
    private List datasourcesList = new LinkedList();

    public DatasourceServicesMetaData(DatasourcesMetaData defaultDatasourcesMeta, DatasourcesMetaData datasourcesMeta) throws Exception {
        if (datasourcesMeta == null) {
            new IllegalArgumentException("null datasources");
        }
        if (defaultDatasourcesMeta == null) {
            new IllegalArgumentException("null defaultDatasources");
        }
        HashMap<String, DatasourceMetaData> defaultDatasources = new HashMap<String, DatasourceMetaData>();
        for (DatasourceMetaData ds : defaultDatasourcesMeta.getDatasources()) {
            defaultDatasources.put(ds.getName(), ds);
        }
        for (DatasourceMetaData ds : datasourcesMeta.getDatasources()) {
            IdentityMetadataProcessor.updateDatasourceWithDefaults(ds, defaultDatasources);
            Map configOptions = ds.getConfig().getOptions();
            HashMap<String, String> optionMap = new HashMap<String, String>();
            for (String optionName : configOptions.keySet()) {
                ConfigOptionMetaData option = (ConfigOptionMetaData)configOptions.get(optionName);
                optionMap.put(optionName, option.getValue());
            }
            this.datasourcesList.add(new DatasourceServiceMetaData(ds, optionMap));
            if (ds.getClassName() != null) continue;
            throw new IdentityException("Class name not found for datasource type: " + ds.getName() + " wrong configuration");
        }
    }

    public List getDatasourcesList() {
        return this.datasourcesList;
    }
}

