/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.identity.service;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.identity.service.BaseRole;

public class BaseRoleImpl
implements BaseRole {
    private static final Log logger = LogFactory.getLog((Class)BaseRoleImpl.class);
    private String _name;
    private HashMap members = new HashMap(3);

    public BaseRoleImpl(String name) {
        this();
        this._name = name;
    }

    public BaseRoleImpl() {
    }

    public boolean addMember(Principal user) {
        boolean isMember = this.members.containsKey(user);
        if (!isMember) {
            this.members.put(user, user);
        }
        return !isMember;
    }

    public boolean isMember(Principal member) {
        boolean isMember = this.members.containsKey(member);
        if (!isMember) {
            Collection values = this.members.values();
            Iterator iter = values.iterator();
            while (!isMember && iter.hasNext()) {
                Object next = iter.next();
                if (!(next instanceof BaseRole)) continue;
                BaseRole role = (BaseRole)next;
                isMember = role.isMember(member);
            }
        }
        return isMember;
    }

    public Enumeration members() {
        return Collections.enumeration(this.members.values());
    }

    public boolean removeMember(Principal user) {
        Object prev = this.members.remove(user);
        return prev != null;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer(this.getName());
        tmp.append("(members:");
        Iterator iter = this.members.keySet().iterator();
        while (iter.hasNext()) {
            tmp.append(iter.next());
            tmp.append(',');
        }
        tmp.setCharAt(tmp.length() - 1, ')');
        return tmp.toString();
    }

    public boolean equals(Object another) {
        if (!(another instanceof BaseRole)) {
            return false;
        }
        String anotherName = ((BaseRole)another).getName();
        boolean equals = false;
        equals = this._name == null ? anotherName == null : this._name.equals(anotherName);
        return equals;
    }

    public int hashCode() {
        return this._name == null ? 0 : this._name.hashCode();
    }
}

