/*
 * Decompiled with CFR 0.152.
 */
package org.josso.applet.agent.jaas;

import java.applet.Applet;
import java.io.IOException;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import netscape.javascript.JSObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AppletAssertionExtractionCallbackHandler
implements CallbackHandler {
    private static final Log logger = LogFactory.getLog(AppletAssertionExtractionCallbackHandler.class);
    private Applet applet;
    private String requester;

    public AppletAssertionExtractionCallbackHandler(Applet applet, String requester) {
        this.applet = applet;
        this.requester = requester;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callbacks[i];
                if (nc.getPrompt().equals("appID")) {
                    nc.setName(this.requester);
                    continue;
                }
                if (nc.getPrompt().equals("endpoint")) {
                    nc.setName(this.getEndpoint());
                    continue;
                }
                nc.setName(this.getCookie("JOSSO_SESSIONID"));
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i]);
        }
    }

    protected String getCookie(String name) {
        JSObject myBrowser = JSObject.getWindow((Applet)this.applet);
        JSObject myDocument = (JSObject)myBrowser.getMember("document");
        String myCookie = (String)myDocument.getMember("cookie");
        String search = name + "=";
        if (myCookie.length() > 0) {
            int offset = myCookie.indexOf(search);
            if (offset != -1) {
                int end = myCookie.indexOf(";", offset += search.length());
                if (end == -1) {
                    end = myCookie.length();
                }
                return myCookie.substring(offset, end);
            }
            return null;
        }
        return null;
    }

    protected String getEndpoint() {
        String endpoint = null;
        Properties agentProperties = new Properties();
        try {
            agentProperties.load(this.getClass().getResource("/META-INF/josso/agent.properties").openStream());
            endpoint = agentProperties.getProperty("ws.locator.endpoint");
        }
        catch (IOException e) {
            logger.error((Object)"WS endpoint isn't configured.", (Throwable)e);
        }
        return endpoint;
    }
}

