/*
 * Decompiled with CFR 0.152.
 */
package org.josso.auth.scheme;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.auth.Credential;
import org.josso.auth.CredentialProvider;
import org.josso.auth.scheme.PasswordCredential;
import org.josso.auth.scheme.UsernameCredential;

public class UsernamePasswordCredentialProvider
implements CredentialProvider {
    public static final String PASSWORD_CREDENTIAL_NAME = "password";
    public static final String USERNAME_CREDENTIAL_NAME = "username";
    private static final Log logger = LogFactory.getLog(UsernamePasswordCredentialProvider.class);

    public Credential newCredential(String name, Object value) {
        if (name.equalsIgnoreCase(USERNAME_CREDENTIAL_NAME)) {
            return new UsernameCredential(value);
        }
        if (name.equalsIgnoreCase(PASSWORD_CREDENTIAL_NAME)) {
            return new PasswordCredential(value);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unknown credential name : " + name));
        }
        return null;
    }

    public Credential newEncodedCredential(String name, Object value) {
        return this.newCredential(name, value);
    }
}

