/*
 * Decompiled with CFR 0.152.
 */
package org.josso.auth.scheme;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.auth.Credential;
import org.josso.auth.CredentialProvider;
import org.josso.auth.SimplePrincipal;
import org.josso.auth.exceptions.SSOAuthenticationException;
import org.josso.auth.scheme.AbstractAuthenticationScheme;
import org.josso.auth.scheme.PasswordCredential;
import org.josso.auth.scheme.UsernameCredential;
import org.josso.auth.scheme.UsernamePasswordCredentialProvider;
import org.josso.auth.util.CipherUtil;
import org.josso.auth.util.Crypt;

public class UsernamePasswordAuthScheme
extends AbstractAuthenticationScheme {
    private static final Log logger = LogFactory.getLog(UsernamePasswordAuthScheme.class);
    private String _hashAlgorithm;
    private String _hashEncoding;
    private String _hashCharset;
    private boolean _ignorePasswordCase;
    private boolean _ignoreUserCase;
    private int _saltLenght = 2;

    public UsernamePasswordAuthScheme() {
        this.setName("basic-authentication");
    }

    public Principal getPrincipal() {
        return new SimplePrincipal(this.getUsername(this._inputCredentials));
    }

    public Principal getPrincipal(Credential[] credentials) {
        return new SimplePrincipal(this.getUsername(credentials));
    }

    public boolean authenticate() throws SSOAuthenticationException {
        this.setAuthenticated(false);
        String username = this.getUsername(this._inputCredentials);
        String password = this.getPassword(this._inputCredentials);
        if (username == null || username.length() == 0 || password == null || password.length() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Username " + (username == null || username.length() == 0 ? " not" : "") + " provided. " + "Password " + (password == null || password.length() == 0 ? " not" : "") + " provided."));
            }
            return false;
        }
        String knownUsername = this.getUsername(this.getKnownCredentials());
        String expectedPassword = this.getPassword(this.getKnownCredentials());
        password = this.createPasswordHash(password);
        if (!this.validateUsername(username, knownUsername) || !this.validatePassword(password, expectedPassword)) {
            return false;
        }
        if (this._ignoreUserCase && !username.equals(knownUsername)) {
            this.updateUsername(this._inputCredentials, knownUsername);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[authenticate()], Principal authenticated : " + username));
        }
        this.setAuthenticated(true);
        return true;
    }

    public Credential[] getPrivateCredentials() {
        PasswordCredential c = this.getPasswordCredential(this._inputCredentials);
        if (c == null) {
            return new Credential[0];
        }
        Credential[] r = new Credential[]{c};
        return r;
    }

    public Credential[] getPublicCredentials() {
        UsernameCredential c = this.getUsernameCredential(this._inputCredentials);
        if (c == null) {
            return new Credential[0];
        }
        Credential[] r = new Credential[]{c};
        return r;
    }

    public Credential newEncodedCredential(String name, Object value) {
        try {
            String v = (String)value;
            if (name.equals("password")) {
                v = this.createPasswordHash(v);
            }
            return super.newEncodedCredential(name, (Object)v);
        }
        catch (SSOAuthenticationException e) {
            logger.error((Object)("Cannot create encoded credential " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Validating passwords [" + inputPassword + "/" + expectedPassword + "]"));
        }
        if (inputPassword == null && expectedPassword == null) {
            return false;
        }
        if (this._ignorePasswordCase && this._hashAlgorithm == null) {
            return inputPassword.equalsIgnoreCase(expectedPassword);
        }
        return inputPassword.equals(expectedPassword);
    }

    protected boolean validateUsername(String inputUsername, String expectedUsername) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Validating usernames [" + inputUsername + "/" + expectedUsername + "]"));
        }
        if (inputUsername == null && expectedUsername == null) {
            return false;
        }
        if (this._ignoreUserCase) {
            return inputUsername.equalsIgnoreCase(expectedUsername);
        }
        return inputUsername.equals(expectedUsername);
    }

    protected String createPasswordHash(String password) throws SSOAuthenticationException {
        byte[] passBytes;
        if (this.getHashAlgorithm() == null && this.getHashEncoding() == null) {
            return password;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating password hash for [" + password + "] with algorithm/encoding [" + this.getHashAlgorithm() + "/" + this.getHashEncoding() + "]"));
        }
        if ("CRYPT".equalsIgnoreCase(this.getHashAlgorithm())) {
            String knownPassword = this.getPassword(this.getKnownCredentials());
            String salt = knownPassword != null && knownPassword.length() > 1 ? knownPassword.substring(0, this._saltLenght) : "";
            return Crypt.crypt((String)salt, (String)password);
        }
        String passwordHash = null;
        try {
            passBytes = this._hashCharset == null ? password.getBytes() : password.getBytes(this._hashCharset);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("charset " + this._hashCharset + " not found. Using platform default."));
            passBytes = password.getBytes();
        }
        try {
            byte[] hash = this._hashAlgorithm != null ? this.getDigest().digest(passBytes) : passBytes;
            if ("BASE64".equalsIgnoreCase(this._hashEncoding)) {
                passwordHash = CipherUtil.encodeBase64((byte[])hash);
            } else if ("HEX".equalsIgnoreCase(this._hashEncoding)) {
                passwordHash = CipherUtil.encodeBase16((byte[])hash);
            } else if (this._hashEncoding == null) {
                logger.error((Object)"You must specify a hashEncoding when using hashAlgorithm");
            } else {
                logger.error((Object)("Unsupported hash encoding format " + this._hashEncoding));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Password hash calculation failed : \n" + e.getMessage() != null ? e.getMessage() : e.toString()), (Throwable)e);
        }
        return passwordHash;
    }

    protected MessageDigest getDigest() throws SSOAuthenticationException {
        MessageDigest _digest = null;
        if (this._hashAlgorithm != null) {
            try {
                _digest = MessageDigest.getInstance(this._hashAlgorithm);
                logger.debug((Object)("Using hash algorithm/encoding : " + this._hashAlgorithm + "/" + this._hashEncoding));
            }
            catch (NoSuchAlgorithmException e) {
                logger.error((Object)("Algorithm not supported : " + this._hashAlgorithm), (Throwable)e);
                throw new SSOAuthenticationException(e.getMessage(), (Throwable)e);
            }
        }
        return _digest;
    }

    protected String getUsername(Credential[] credentials) {
        UsernameCredential c = this.getUsernameCredential(credentials);
        if (c == null) {
            return null;
        }
        return (String)c.getValue();
    }

    protected String getPassword(Credential[] credentials) {
        PasswordCredential p = this.getPasswordCredential(credentials);
        if (p == null) {
            return null;
        }
        return (String)p.getValue();
    }

    protected void updateUsername(Credential[] credentials, String username) {
        UsernameCredential c = this.getUsernameCredential(credentials);
        if (c != null) {
            c.setValue(username);
        }
    }

    protected PasswordCredential getPasswordCredential(Credential[] credentials) {
        for (int i = 0; i < credentials.length; ++i) {
            if (!(credentials[i] instanceof PasswordCredential)) continue;
            return (PasswordCredential)credentials[i];
        }
        return null;
    }

    protected UsernameCredential getUsernameCredential(Credential[] credentials) {
        for (int i = 0; i < credentials.length; ++i) {
            if (!(credentials[i] instanceof UsernameCredential)) continue;
            return (UsernameCredential)credentials[i];
        }
        return null;
    }

    protected CredentialProvider doMakeCredentialProvider() {
        return new UsernamePasswordCredentialProvider();
    }

    public String getHashAlgorithm() {
        return this._hashAlgorithm;
    }

    public void setHashAlgorithm(String hashAlgorithm) {
        if (hashAlgorithm != null && hashAlgorithm.equals("")) {
            hashAlgorithm = null;
        }
        this._hashAlgorithm = hashAlgorithm;
    }

    public String getHashEncoding() {
        return this._hashEncoding;
    }

    public void setHashEncoding(String hashEnconding) {
        if (hashEnconding != null && hashEnconding.equals("")) {
            hashEnconding = null;
        }
        this._hashEncoding = hashEnconding;
    }

    public String getHashCharset() {
        return this._hashCharset;
    }

    public void setHashCharset(String hashCharset) {
        this._hashCharset = hashCharset;
    }

    public void setSaltLenght(String saltLenght) {
        this.setSaltLength(Integer.valueOf(saltLenght));
    }

    public int getSaltLength() {
        return this._saltLenght;
    }

    public void setSaltLength(int sl) {
        this._saltLenght = sl;
    }

    public void setIgnorePasswordCase(String ignorePasswordCase) {
        this._ignorePasswordCase = Boolean.valueOf(ignorePasswordCase);
    }

    public void setIgnoreUserCase(String ignoreUserCase) {
        this._ignoreUserCase = Boolean.valueOf(ignoreUserCase);
    }

    public Object clone() {
        UsernamePasswordAuthScheme s = (UsernamePasswordAuthScheme)((Object)super.clone());
        s.setHashAlgorithm(this._hashAlgorithm);
        s.setHashCharset(this._hashCharset);
        s.setHashEncoding(this._hashEncoding);
        s.setIgnorePasswordCase(this._ignorePasswordCase + "");
        s.setIgnoreUserCase(this._ignoreUserCase + "");
        s.setName(this._name);
        return s;
    }
}

