/*
 * Decompiled with CFR 0.152.
 */
package org.josso.auth.scheme;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.auth.BindableCredentialStore;
import org.josso.auth.CredentialStore;
import org.josso.auth.exceptions.SSOAuthenticationException;
import org.josso.auth.scheme.UsernamePasswordAuthScheme;

public class BindUsernamePasswordAuthScheme
extends UsernamePasswordAuthScheme {
    private static final Log logger = LogFactory.getLog(BindUsernamePasswordAuthScheme.class);

    public BindUsernamePasswordAuthScheme() {
        this.setName("bind-authentication");
    }

    public boolean authenticate() throws SSOAuthenticationException {
        this.setAuthenticated(false);
        String username = this.getUsername(this._inputCredentials);
        String password = this.getPassword(this._inputCredentials);
        if (username == null || username.length() == 0 || password == null || password.length() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Username " + (username == null || username.length() == 0 ? " not" : "") + " provided. " + "Password " + (password == null || password.length() == 0 ? " not" : "") + " provided."));
            }
            return false;
        }
        if (((BindableCredentialStore)this._credentialStore).bind(username, password)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[authenticate()], Principal authenticated : " + username));
            }
            this.setAuthenticated(true);
            return true;
        }
        return false;
    }

    public void setCredentialStore(CredentialStore c) {
        if (!(c instanceof BindableCredentialStore)) {
            throw new RuntimeException("Invalid credential store type, it must be instace of " + BindableCredentialStore.class.getName());
        }
        super.setCredentialStore(c);
    }
}

