/*
 * Decompiled with CFR 0.152.
 */
package org.josso.seam.console;

import java.security.MessageDigest;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.validator.Length;
import org.hibernate.validator.NotNull;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.log.Log;
import org.jboss.seam.security.Identity;
import org.josso.seam.console.Register;
import org.josso.seam.console.UsernameHome;
import org.josso.seam.console.model.Username;

@Stateless
@Name(value="register")
public class RegisterBean
implements Register {
    @Logger
    private Log log;
    @PersistenceContext
    private EntityManager em;
    @In
    FacesMessages facesMessages;
    @In
    UsernameHome usernameHome;
    @In
    Identity identity;
    private String password;
    private String confirm;

    public String register() {
        if (this.password.equals(this.confirm)) {
            String hash = null;
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("MD5");
                byte[] raw = md.digest(this.password.getBytes());
                hash = this.encodeBase16(raw);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.log.info((Object)"Register.register() action called", new Object[0]);
            Username username = (Username)this.usernameHome.getInstance();
            username.setPasswd(hash);
            this.em.persist((Object)username);
            return "success";
        }
        this.facesMessages.add("Passwords are not identical.", new Object[0]);
        return "failure";
    }

    public String update() {
        if (this.password.equals(this.confirm)) {
            String hash = null;
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("MD5");
                byte[] raw = md.digest(this.password.getBytes());
                hash = this.encodeBase16(raw);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.log.info((Object)"Register.register() action called", new Object[0]);
            Username username = (Username)this.usernameHome.getInstance();
            username.setPasswd(hash);
            String user = this.identity.getUsername();
            Boolean isAdmin = this.identity.hasRole("admin");
            if (!user.equals(username.getLogin()) && !isAdmin.booleanValue()) {
                this.facesMessages.add("Only the user or the admin can make updates.", new Object[0]);
                return "failure";
            }
            this.em.merge((Object)username);
            return "success";
        }
        this.facesMessages.add("Passwords are not identical", new Object[0]);
        return "failure";
    }

    @NotNull
    @Length(min=4, max=32)
    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    @NotNull
    @Length(min=4, max=32)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    protected String encodeBase16(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            char c = (char)(b >> 4 & 0xF);
            c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
            sb.append(c);
            c = (char)(b & 0xF);
            c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
            sb.append(c);
        }
        return sb.toString();
    }
}

