/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.protocol;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.auth.Credential;
import org.josso.auth.exceptions.SSOAuthenticationException;
import org.josso.gateway.protocol.SSOProtocolManager;
import org.josso.gateway.protocol.handler.ProtocolHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSOProtocolManagerImpl
implements SSOProtocolManager {
    private static final Log logger = LogFactory.getLog(SSOProtocolManagerImpl.class);
    private List<ProtocolHandler> handlers = new ArrayList<ProtocolHandler>();

    @Override
    public void initialize() {
    }

    @Override
    public boolean dispatchRequest(HttpServletRequest request, HttpServletResponse response) {
        for (ProtocolHandler ph : this.handlers) {
            if (!ph.acceptJob(request, response)) continue;
            return ph.doJob(request, response);
        }
        return true;
    }

    @Override
    public boolean authenticate(Credential[] credentials) throws SSOAuthenticationException {
        ProtocolHandler ph;
        boolean authenticationSucceded = false;
        Iterator<ProtocolHandler> iterator = this.handlers.iterator();
        while (iterator.hasNext() && !(authenticationSucceded = (ph = iterator.next()).authenticate(credentials))) {
        }
        return authenticationSucceded;
    }

    public List<ProtocolHandler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(List<ProtocolHandler> handlers) {
        this.handlers = handlers;
    }

    @Override
    public void dispose() {
    }
}

