/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.assertion.service.store.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.assertion.AuthenticationAssertion;
import org.josso.gateway.assertion.MutableAuthenticationAssertion;
import org.josso.gateway.assertion.exceptions.AssertionException;
import org.josso.gateway.assertion.service.store.AbstractAssertionStore;

public abstract class DbAssertionStore
extends AbstractAssertionStore {
    private static final Log __log = LogFactory.getLog(DbAssertionStore.class);
    private String _sizeQuery = null;
    private String _keysQuery = null;
    private String _loadAllQuery = null;
    private String _loadQuery = null;
    private String _deleteDml = null;
    private String _deleteAllDml = null;
    private String _insertDml = null;

    protected abstract Connection getConnection() throws SQLException, AssertionException;

    protected void close(Connection dbConnection) throws AssertionException {
        try {
            if (dbConnection != null && !dbConnection.isClosed()) {
                dbConnection.close();
            }
        }
        catch (SQLException se) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)"Error while clossing connection");
            }
            throw new AssertionException("Error while clossing connection\n" + se.getMessage());
        }
        catch (Exception e) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)"Error while clossing connection");
            }
            throw new AssertionException("Error while clossing connection\n" + e.getMessage());
        }
    }

    protected void close(Statement statement) throws AssertionException {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException se) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)"Error while clossing statement");
            }
            throw new AssertionException("Error while clossing statement\n" + se.getMessage());
        }
        catch (Exception e) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)"Error while clossing statement");
            }
            throw new AssertionException("Error while clossing statement\n" + e.getMessage());
        }
    }

    public void setInsertDml(String query) {
        this._insertDml = query;
    }

    public String getInsertDml() {
        return this._insertDml;
    }

    public void setDeleteAllDml(String query) {
        this._deleteAllDml = query;
    }

    public String getDeleteAllDml() {
        return this._deleteAllDml;
    }

    public void setDeleteDml(String query) {
        this._deleteDml = query;
    }

    public String getDeleteDml() {
        return this._deleteDml;
    }

    public void setSizeQuery(String query) {
        this._sizeQuery = query;
    }

    public String getSizeQuery() {
        return this._sizeQuery;
    }

    public void setKeysQuery(String query) {
        this._keysQuery = query;
    }

    public String getKeysQuery() {
        return this._keysQuery;
    }

    public void setLoadAllQuery(String query) {
        this._loadAllQuery = query;
    }

    public String getLoadAllQuery() {
        return this._loadAllQuery;
    }

    public void setLoadQuery(String query) {
        this._loadQuery = query;
    }

    public String getLoadQuery() {
        return this._loadQuery;
    }

    public int getSize() throws AssertionException {
        int retval = 0;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getConnection();
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(this._sizeQuery);
            if (rs != null && rs.next()) {
                retval = rs.getInt(1);
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e) {
            try {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)e, (Throwable)e);
                }
                throw new AssertionException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.close(conn);
                throw throwable;
            }
        }
        this.close(stmt);
        this.close(conn);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Returning " + retval));
        }
        return retval;
    }

    public String[] keys() throws AssertionException {
        String[] retval = null;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getConnection();
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(this._keysQuery);
            ArrayList<String> bucket = new ArrayList<String>();
            while (rs.next()) {
                bucket.add(rs.getString(1));
            }
            rs.close();
            retval = new String[bucket.size()];
            bucket.toArray(retval);
        }
        catch (Exception e) {
            try {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)e, (Throwable)e);
                }
                throw new AssertionException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.close(conn);
                throw throwable;
            }
        }
        this.close(stmt);
        this.close(conn);
        return retval;
    }

    public AuthenticationAssertion[] loadAll() throws AssertionException {
        AuthenticationAssertion[] retval = null;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getConnection();
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(this._loadAllQuery);
            retval = this.getAssertions(rs);
            rs.close();
        }
        catch (Exception e) {
            try {
                __log.error((Object)e, (Throwable)e);
                throw new AssertionException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.close(conn);
                throw throwable;
            }
        }
        this.close(stmt);
        this.close(conn);
        return retval;
    }

    public AuthenticationAssertion load(String id) throws AssertionException {
        AuthenticationAssertion retval = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(this._loadQuery);
            stmt.setString(1, id);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                retval = this.createFromResultSet(rs);
            }
            rs.close();
        }
        catch (Exception e) {
            try {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)e, (Throwable)e);
                }
                throw new AssertionException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.close(conn);
                throw throwable;
            }
        }
        this.close(stmt);
        this.close(conn);
        String string = id = retval == null ? "NOT FOUND" : retval.getId();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Loaded assertion: " + id));
        }
        return retval;
    }

    public void remove(String id) throws AssertionException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            this.delete(conn, id);
            conn.commit();
        }
        catch (Exception e) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)e, (Throwable)e);
            }
            throw new AssertionException((Throwable)e);
        }
        finally {
            this.close(conn);
        }
    }

    public void clear() throws AssertionException {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getConnection();
            stmt = conn.createStatement();
            stmt.execute(this._deleteAllDml);
            conn.commit();
            stmt.close();
        }
        catch (Exception e) {
            try {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)e, (Throwable)e);
                }
                throw new AssertionException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.close(conn);
                throw throwable;
            }
        }
        this.close(stmt);
        this.close(conn);
    }

    public void save(AuthenticationAssertion assertion) throws AssertionException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            this.delete(conn, assertion.getId());
            this.insert(conn, assertion);
            conn.commit();
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Assertion committed: " + assertion.getId()));
            }
        }
        catch (Exception e) {
            block12: {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)e, (Throwable)e);
                }
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException sqle) {
                        if (!__log.isDebugEnabled()) break block12;
                        __log.debug((Object)"Error during ROLLBACK ", (Throwable)sqle);
                    }
                }
            }
            throw new AssertionException((Throwable)e);
        }
        finally {
            this.close(conn);
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Saved assertion: " + assertion.getId()));
        }
    }

    protected void delete(Connection conn, String assertionId) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(this._deleteDml);
        ps.setString(1, assertionId);
        ps.execute();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Assertion Removed: " + assertionId));
        }
    }

    protected void insert(Connection conn, AuthenticationAssertion assertion) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(this._insertDml);
        ps.setString(1, assertion.getId());
        ps.setString(2, "default");
        ps.setString(3, assertion.getSSOSessionId());
        ps.setLong(4, assertion.getCreationTime());
        ps.setBoolean(5, assertion.isValid());
        ps.execute();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Creation, LastAccess: " + assertion.getCreationTime() + ", " + assertion.getCreationTime()));
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Assertion inserted: " + assertion.getId()));
        }
    }

    protected AuthenticationAssertion[] getAssertions(ResultSet rs) throws SQLException {
        ArrayList<AuthenticationAssertion> bucket = new ArrayList<AuthenticationAssertion>();
        while (rs.next()) {
            bucket.add(this.createFromResultSet(rs));
        }
        AuthenticationAssertion[] retval = new AuthenticationAssertion[bucket.size()];
        bucket.toArray(retval);
        return retval;
    }

    protected AuthenticationAssertion createFromResultSet(ResultSet rs) throws SQLException {
        MutableAuthenticationAssertion bsi = new MutableAuthenticationAssertion(rs.getString(1));
        bsi.setSecurityDomainName(rs.getString(2));
        bsi.setSSOSessionId(rs.getString(3));
        bsi.setCreationTime(rs.getLong(4));
        bsi.setValid(rs.getBoolean(5));
        return bsi;
    }
}

