/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.identity.service.store.db;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.auth.BaseCredential;
import org.josso.auth.Credential;
import org.josso.auth.CredentialKey;
import org.josso.auth.CredentialProvider;
import org.josso.gateway.SSONameValuePair;
import org.josso.gateway.identity.exceptions.NoSuchUserException;
import org.josso.gateway.identity.exceptions.SSOIdentityException;
import org.josso.gateway.identity.service.BaseRole;
import org.josso.gateway.identity.service.BaseUser;
import org.josso.gateway.identity.service.store.AbstractStore;
import org.josso.gateway.identity.service.store.ExtendedIdentityStore;
import org.josso.gateway.identity.service.store.SimpleUserKey;
import org.josso.gateway.identity.service.store.UserKey;
import org.josso.gateway.identity.service.store.db.IdentityDAO;
import org.josso.selfservices.ChallengeResponseCredential;

public abstract class AbstractDBIdentityStore
extends AbstractStore
implements ExtendedIdentityStore {
    private static final Log logger = LogFactory.getLog(AbstractDBIdentityStore.class);
    private String _userQueryString;
    private String _rolesQueryString;
    private String _credentialsQueryString;
    private String _certificateCredentialsQueryString;
    private String _uidQueryString;
    private String _userPropertiesQueryString;
    private String _resetCredentialDml;
    private String _relayCredentialQueryString;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseUser loadUser(UserKey key) throws NoSuchUserException, SSOIdentityException {
        BaseUser baseUser;
        Connection c = null;
        try {
            if (!(key instanceof SimpleUserKey)) {
                throw new SSOIdentityException("Unsupported key type : " + key.getClass().getName());
            }
            c = this.getDBConnection();
            IdentityDAO dao = this.getIdentityDAO(c);
            BaseUser user = dao.selectUser((SimpleUserKey)key);
            if (this.getUserPropertiesQueryString() != null) {
                SSONameValuePair[] props = dao.selectUserProperties((SimpleUserKey)key);
                user.setProperties(props);
            }
            baseUser = user;
        }
        catch (Throwable throwable) {
            this.closeDBConnection(c);
            throw throwable;
        }
        this.closeDBConnection(c);
        return baseUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseRole[] findRolesByUserKey(UserKey key) throws SSOIdentityException {
        BaseRole[] baseRoleArray;
        Connection c = null;
        try {
            BaseRole[] roles;
            if (!(key instanceof SimpleUserKey)) {
                throw new SSOIdentityException("Unsupported key type : " + key.getClass().getName());
            }
            c = this.getDBConnection();
            IdentityDAO dao = this.getIdentityDAO(c);
            baseRoleArray = roles = dao.selectRolesByUserKey((SimpleUserKey)key);
        }
        catch (Throwable throwable) {
            this.closeDBConnection(c);
            throw throwable;
        }
        this.closeDBConnection(c);
        return baseRoleArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credential[] loadCredentials(CredentialKey key, CredentialProvider cp) throws SSOIdentityException {
        Credential[] credentialArray;
        Connection c = null;
        try {
            Credential[] credentials;
            if (!(key instanceof SimpleUserKey)) {
                throw new SSOIdentityException("Unsupported key type : " + key.getClass().getName());
            }
            c = this.getDBConnection();
            IdentityDAO dao = this.getIdentityDAO(c, cp);
            credentialArray = credentials = dao.selectCredentials((SimpleUserKey)key);
        }
        catch (Throwable throwable) {
            this.closeDBConnection(c);
            throw throwable;
        }
        this.closeDBConnection(c);
        return credentialArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadUID(CredentialKey key, CredentialProvider cp) throws SSOIdentityException {
        String string;
        Connection c = null;
        try {
            if (!(key instanceof SimpleUserKey)) {
                throw new SSOIdentityException("Unsupported key type : " + key.getClass().getName());
            }
            c = this.getDBConnection();
            IdentityDAO dao = this.getIdentityDAO(c, cp);
            string = dao.loadUID(key);
        }
        catch (Throwable throwable) {
            this.closeDBConnection(c);
            throw throwable;
        }
        this.closeDBConnection(c);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadUsernameByRelayCredential(ChallengeResponseCredential cred) throws SSOIdentityException {
        Connection c = null;
        try {
            c = this.getDBConnection();
            IdentityDAO dao = this.getIdentityDAO(c);
            String string = dao.resolveUsernameByRelayCredential(cred.getId(), cred.getResponse());
            return string;
        }
        finally {
            this.closeDBConnection(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAccountPassword(UserKey key, Credential newPassword) throws SSOIdentityException {
        Connection c = null;
        try {
            if (!(newPassword instanceof BaseCredential)) {
                throw new SSOIdentityException("Unsupported Credential type : " + newPassword.getClass().getName());
            }
            if (!(key instanceof SimpleUserKey)) {
                throw new SSOIdentityException("Unsupported UserKey type : " + key.getClass().getName());
            }
            c = this.getDBConnection();
            IdentityDAO dao = this.getIdentityDAO(c);
            dao.resetCredential((SimpleUserKey)key, (BaseCredential)newPassword);
        }
        catch (Throwable throwable) {
            this.closeDBConnection(c);
            throw throwable;
        }
        this.closeDBConnection(c);
    }

    protected abstract Connection getDBConnection() throws SSOIdentityException;

    protected IdentityDAO getIdentityDAO(Connection c, CredentialProvider cp) {
        return new IdentityDAO(c, cp, this.getUserQueryString(), this.getRolesQueryString(), this.getCredentialsQueryString(), this.getUserPropertiesQueryString(), this.getResetCredentialDml(), this.getRelayCredentialQueryString(), this.getCertificateCredentialsQueryString(), this.getUidQueryString());
    }

    protected IdentityDAO getIdentityDAO(Connection c) {
        return new IdentityDAO(c, null, this.getUserQueryString(), this.getRolesQueryString(), this.getCredentialsQueryString(), this.getUserPropertiesQueryString(), this.getResetCredentialDml(), this.getRelayCredentialQueryString(), this.getCertificateCredentialsQueryString(), this.getUidQueryString());
    }

    protected void closeDBConnection(Connection dbConnection) throws SSOIdentityException {
        try {
            if (dbConnection != null && !dbConnection.isClosed()) {
                dbConnection.close();
            }
        }
        catch (SQLException se) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Error while clossing connection");
            }
            throw new SSOIdentityException("Error while clossing connection\n" + se.getMessage());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Error while clossing connection");
            }
            throw new SSOIdentityException("Error while clossing connection\n" + e.getMessage());
        }
    }

    public String getUserQueryString() {
        return this._userQueryString;
    }

    public String getRolesQueryString() {
        return this._rolesQueryString;
    }

    public String getCredentialsQueryString() {
        return this._credentialsQueryString;
    }

    public String getCertificateCredentialsQueryString() {
        return this._certificateCredentialsQueryString;
    }

    public String getUidQueryString() {
        return this._uidQueryString;
    }

    public String getUserPropertiesQueryString() {
        return this._userPropertiesQueryString;
    }

    public void setUserQueryString(String userQueryString) {
        this._userQueryString = userQueryString;
    }

    public void setRolesQueryString(String rolesQueryString) {
        this._rolesQueryString = rolesQueryString;
    }

    public void setCredentialsQueryString(String credentialsQueryString) {
        this._credentialsQueryString = credentialsQueryString;
    }

    public void setCertificateCredentialsQueryString(String certificateCredentialsQueryString) {
        this._certificateCredentialsQueryString = certificateCredentialsQueryString;
    }

    public void setUidQueryString(String uidQueryString) {
        this._uidQueryString = uidQueryString;
    }

    public void setUserPropertiesQueryString(String userPropertiesQueryString) {
        this._userPropertiesQueryString = userPropertiesQueryString;
    }

    public String getResetCredentialDml() {
        return this._resetCredentialDml;
    }

    public void setResetCredentialDml(String resetCredentialDml) {
        this._resetCredentialDml = resetCredentialDml;
    }

    public String getRelayCredentialQueryString() {
        return this._relayCredentialQueryString;
    }

    public void setRelayCredentialQueryString(String relayCredentialQueryString) {
        this._relayCredentialQueryString = relayCredentialQueryString;
    }
}

