/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.identity.service.store.db;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.identity.exceptions.SSOIdentityException;
import org.josso.gateway.identity.service.store.db.AbstractDBIdentityStore;

public class DataSourceIdentityStore
extends AbstractDBIdentityStore {
    private static final Log logger = LogFactory.getLog(DataSourceIdentityStore.class);
    private String _dsJndiName;
    private DataSource _datasource;

    public void setDsJndiName(String dsJndiName) {
        this._dsJndiName = dsJndiName;
        this._datasource = null;
    }

    protected DataSource getDataSource() throws SSOIdentityException {
        if (this._datasource == null) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[getDatasource() : ]" + this._dsJndiName));
                }
                InitialContext ic = new InitialContext();
                this._datasource = (DataSource)ic.lookup(this._dsJndiName);
            }
            catch (NamingException ne) {
                logger.error((Object)"Error during DB connection lookup", (Throwable)ne);
                throw new SSOIdentityException("Error During Lookup\n" + ne.getMessage());
            }
        }
        return this._datasource;
    }

    protected Connection getDBConnection() throws SSOIdentityException {
        try {
            return this.getDataSource().getConnection();
        }
        catch (SQLException e) {
            logger.error((Object)("[getDBConnection()]:" + e.getErrorCode() + "/" + e.getSQLState() + "]" + e.getMessage()));
            throw new SSOIdentityException("Exception while getting connection: \n " + e.getMessage());
        }
    }
}

