/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.identity.service.store.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.auth.BaseCredential;
import org.josso.auth.Credential;
import org.josso.auth.CredentialKey;
import org.josso.auth.CredentialProvider;
import org.josso.auth.exceptions.SSOAuthenticationException;
import org.josso.auth.scheme.AuthenticationScheme;
import org.josso.gateway.SSONameValuePair;
import org.josso.gateway.identity.exceptions.SSOIdentityException;
import org.josso.gateway.identity.service.BaseRole;
import org.josso.gateway.identity.service.BaseRoleImpl;
import org.josso.gateway.identity.service.BaseUser;
import org.josso.gateway.identity.service.BaseUserImpl;
import org.josso.gateway.identity.service.store.CertificateUserKey;
import org.josso.gateway.identity.service.store.SimpleUserKey;

public class IdentityDAO {
    private static final Log logger = LogFactory.getLog(IdentityDAO.class);
    private Connection _conn;
    private CredentialProvider _cp;
    private String _userQueryString;
    private String _rolesQueryString;
    private String _credentialsQueryString;
    private String _certificateCredentialsQueryString;
    private String _uidQueryString;
    private String _userPropertiesQueryString;
    private int _userPropertiesQueryVariables = 0;
    private String _resetCredentialDml;
    private String _relayCredentialQueryString;

    public IdentityDAO(Connection conn, CredentialProvider cp, String userQueryString, String rolesQueryString, String credentialsQueryString, String userPropertiesQueryString, String resetCredentialDml, String relayCredentialQueryString, String certificateCredentialsQueryString, String uidQueryString) {
        this._conn = conn;
        this._cp = cp;
        this._userQueryString = userQueryString;
        this._rolesQueryString = rolesQueryString;
        this._credentialsQueryString = credentialsQueryString;
        this._certificateCredentialsQueryString = certificateCredentialsQueryString;
        this._uidQueryString = uidQueryString;
        this._resetCredentialDml = resetCredentialDml;
        this._relayCredentialQueryString = relayCredentialQueryString;
        if (userPropertiesQueryString != null) {
            this._userPropertiesQueryString = userPropertiesQueryString;
            this._userPropertiesQueryVariables = this.countQueryVariables(this._userPropertiesQueryString);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseUser selectUser(SimpleUserKey key) throws SSOIdentityException {
        BaseUser baseUser;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = this.createPreparedStatement(this._userQueryString);
            stmt.setString(1, key.getId());
            result = stmt.executeQuery();
            BaseUser user = this.fetchUser(result);
            if (user == null) {
                throw new SSOIdentityException("Can't find user for : " + key);
            }
            baseUser = user;
        }
        catch (SQLException sqlE) {
            try {
                logger.error((Object)"SQLException while listing user", (Throwable)sqlE);
                throw new SSOIdentityException("During user listing: " + sqlE.getMessage());
                catch (IOException ioE) {
                    logger.error((Object)"IOException while listing user", (Throwable)ioE);
                    throw new SSOIdentityException("During user listing: " + ioE.getMessage());
                }
                catch (Exception e) {
                    logger.error((Object)"Exception while listing user", (Throwable)e);
                    throw new SSOIdentityException("During user listing: " + e.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeResultSet(result);
                this.closeStatement(stmt);
                throw throwable;
            }
        }
        this.closeResultSet(result);
        this.closeStatement(stmt);
        return baseUser;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseRole[] selectRolesByUserKey(SimpleUserKey key) throws SSOIdentityException {
        BaseRole[] baseRoleArray;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            BaseRole[] roles;
            stmt = this.createPreparedStatement(this._rolesQueryString);
            stmt.setString(1, key.getId());
            result = stmt.executeQuery();
            baseRoleArray = roles = this.fetchRoles(result);
        }
        catch (SQLException sqlE) {
            try {
                logger.error((Object)"SQLException while listing roles", (Throwable)sqlE);
                throw new SSOIdentityException("During roles listing: " + sqlE.getMessage());
                catch (IOException ioE) {
                    logger.error((Object)"IOException while listing roles", (Throwable)ioE);
                    throw new SSOIdentityException("During roles listing: " + ioE.getMessage());
                }
                catch (Exception e) {
                    logger.error((Object)"Exception while listing roles", (Throwable)e);
                    throw new SSOIdentityException("During roles listing: " + e.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeResultSet(result);
                this.closeStatement(stmt);
                throw throwable;
            }
        }
        this.closeResultSet(result);
        this.closeStatement(stmt);
        return baseRoleArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Credential[] selectCredentials(SimpleUserKey key) throws SSOIdentityException {
        Credential[] credentialArray;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            Credential[] creds;
            String credentialsQueryString = this._credentialsQueryString;
            String schemeName = null;
            if (this._cp instanceof AuthenticationScheme) {
                schemeName = ((AuthenticationScheme)this._cp).getName();
            }
            if ("strong-authentication".equals(schemeName)) {
                credentialsQueryString = this._certificateCredentialsQueryString;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[selectCredemtiasl()]]: key=" + key.getId()));
            }
            stmt = this.createPreparedStatement(credentialsQueryString);
            stmt.setString(1, key.getId());
            result = stmt.executeQuery();
            credentialArray = creds = this.fetchCredentials(result);
        }
        catch (SQLException sqlE) {
            try {
                logger.error((Object)"SQLException while listing credentials", (Throwable)sqlE);
                throw new SSOIdentityException("During credentials listing: " + sqlE.getMessage());
                catch (IOException ioE) {
                    logger.error((Object)"IOException while listing credentials", (Throwable)ioE);
                    throw new SSOIdentityException("During credentials listing: " + ioE.getMessage());
                }
                catch (Exception e) {
                    logger.error((Object)"Exception while listing credentials", (Throwable)e);
                    throw new SSOIdentityException("During credentials listing: " + e.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeResultSet(result);
                this.closeStatement(stmt);
                throw throwable;
            }
        }
        this.closeResultSet(result);
        this.closeStatement(stmt);
        return credentialArray;
    }

    public String loadUID(CredentialKey key) throws SSOIdentityException {
        PreparedStatement stmt = null;
        ResultSet result = null;
        String uid = null;
        try {
            if (key instanceof CertificateUserKey) {
                X509Certificate certificate = ((CertificateUserKey)key).getCertificate();
                if (certificate != null) {
                    stmt = this.createPreparedStatement(this._uidQueryString);
                    stmt.setBytes(1, certificate.getEncoded());
                    result = stmt.executeQuery();
                    if (result.next()) {
                        uid = result.getString(1);
                    }
                }
            } else if (key instanceof SimpleUserKey) {
                uid = ((SimpleUserKey)key).getId();
            }
        }
        catch (SQLException sqlE) {
            logger.error((Object)"SQLException while finding UID", (Throwable)sqlE);
            throw new SSOIdentityException("During UID lookup: " + sqlE.getMessage());
        }
        catch (Exception e) {
            logger.error((Object)"Exception while finding UID", (Throwable)e);
            throw new SSOIdentityException("During UID lookup: " + e.getMessage());
        }
        finally {
            this.closeResultSet(result);
            this.closeStatement(stmt);
        }
        return uid;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SSONameValuePair[] selectUserProperties(SimpleUserKey key) throws SSOIdentityException {
        SSONameValuePair[] sSONameValuePairArray;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            SSONameValuePair[] props;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[selectUserProperties()]]: key=" + key.getId()));
            }
            stmt = this.createPreparedStatement(this._userPropertiesQueryString);
            for (int i = 1; i <= this._userPropertiesQueryVariables; ++i) {
                stmt.setString(i, key.getId());
            }
            result = stmt.executeQuery();
            sSONameValuePairArray = props = this.fetchSSONameValuePairs(result);
        }
        catch (SQLException sqlE) {
            try {
                logger.error((Object)"SQLException while listing user properties", (Throwable)sqlE);
                throw new SSOIdentityException("During user properties listing: " + sqlE.getMessage());
                catch (IOException ioE) {
                    logger.error((Object)"IOException while listing user properties", (Throwable)ioE);
                    throw new SSOIdentityException("During user properties listing: " + ioE.getMessage());
                }
                catch (Exception e) {
                    logger.error((Object)"Exception while listing user properties", (Throwable)e);
                    throw new SSOIdentityException("During user properties listing: " + e.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeResultSet(result);
                this.closeStatement(stmt);
                throw throwable;
            }
        }
        this.closeResultSet(result);
        this.closeStatement(stmt);
        return sSONameValuePairArray;
    }

    public void resetCredential(SimpleUserKey key, BaseCredential newPassword) throws SSOIdentityException {
        PreparedStatement stmt = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[resetCredential()]]: key=" + key.getId()));
            }
            stmt = this.createPreparedStatement(this._resetCredentialDml);
            stmt.setString(1, newPassword.getValue().toString());
            stmt.setString(2, key.getId());
            stmt.execute();
            this._conn.commit();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"SQLException while updating user credential", (Throwable)e);
                throw new SSOIdentityException("During user update credential: " + e.getMessage());
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String resolveUsernameByRelayCredential(String name, String value) throws SSOIdentityException {
        String string;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            String username;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[resolveUsernameByRelayCredential(name, value)]]: name=" + name + " value=" + value));
            }
            if (this._relayCredentialQueryString.contains("#?#")) {
                stmt = this.createPreparedStatement(this._relayCredentialQueryString.replace("#?#", name));
                stmt.setString(1, value);
            } else {
                stmt = this.createPreparedStatement(this._relayCredentialQueryString);
                stmt.setString(1, name);
                stmt.setString(2, value);
            }
            result = stmt.executeQuery();
            String string2 = username = result.next() ? result.getString(1) : null;
            if (result.next()) {
                throw new SSOIdentityException("Statement " + stmt + " returned more than one row");
            }
            string = username;
        }
        catch (SQLException sqlE) {
            try {
                logger.error((Object)"SQLException while loading user with relay credential", (Throwable)sqlE);
                throw new SSOIdentityException("During load user with relay credential: " + sqlE.getMessage());
                catch (Exception e) {
                    logger.error((Object)"Exception while loading user with relay credential", (Throwable)e);
                    throw new SSOIdentityException("During load user with relay credential: " + e.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeResultSet(result);
                this.closeStatement(stmt);
                throw throwable;
            }
        }
        this.closeResultSet(result);
        this.closeStatement(stmt);
        return string;
    }

    protected Credential[] fetchCredentials(ResultSet rs) throws SQLException, IOException, SSOAuthenticationException {
        ArrayList<Credential> creds = new ArrayList<Credential>();
        while (rs.next()) {
            ResultSetMetaData md = rs.getMetaData();
            for (int i = 1; i <= md.getColumnCount(); ++i) {
                String cName = md.getColumnLabel(i);
                Object credentialObject = rs.getObject(i);
                String credentialValue = null;
                if (credentialObject.getClass().isArray()) {
                    try {
                        byte[] credentialData = (byte[])credentialObject;
                        ByteBuffer in = ByteBuffer.allocate(credentialData.length);
                        in.put(credentialData);
                        in.flip();
                        Charset charset = Charset.forName("UTF-8");
                        CharsetDecoder decoder = charset.newDecoder();
                        CharBuffer charBuffer = decoder.decode(in);
                        credentialValue = charBuffer.toString();
                    }
                    catch (CharacterCodingException e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Can't convert credential value to String using UTF-8");
                        }
                    }
                } else if (credentialObject instanceof String) {
                    credentialValue = (String)credentialObject;
                }
                Credential c = null;
                c = credentialValue != null ? this._cp.newCredential(cName, (Object)credentialValue) : this._cp.newCredential(cName, credentialObject);
                if (c == null) continue;
                creds.add(c);
            }
        }
        return creds.toArray(new Credential[creds.size()]);
    }

    protected SSONameValuePair[] fetchSSONameValuePairs(ResultSet rs) throws SQLException, IOException, SSOAuthenticationException {
        ArrayList<SSONameValuePair> props = new ArrayList<SSONameValuePair>();
        while (rs.next()) {
            String cName = rs.getString(1);
            String cValue = rs.getString(2);
            SSONameValuePair prop = new SSONameValuePair(cName, cValue);
            props.add(prop);
        }
        return props.toArray(new SSONameValuePair[props.size()]);
    }

    protected BaseRole[] fetchRoles(ResultSet rs) throws SQLException, IOException {
        ArrayList<BaseRoleImpl> roles = new ArrayList<BaseRoleImpl>();
        while (rs.next()) {
            BaseRoleImpl role = new BaseRoleImpl();
            String rolename = rs.getString(1);
            role.setName(rolename);
            roles.add(role);
        }
        return roles.toArray(new BaseRole[roles.size()]);
    }

    protected BaseUser fetchUser(ResultSet rs) throws SQLException, IOException {
        if (rs.next()) {
            BaseUserImpl user = new BaseUserImpl();
            String username = rs.getString(1);
            user.setName(username);
            return user;
        }
        return null;
    }

    private PreparedStatement createPreparedStatement(String query) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[createPreparedStatement()] : (" + query + ")"));
        }
        PreparedStatement stmt = this._conn.prepareStatement(query + " ");
        return stmt;
    }

    protected void closeStatement(PreparedStatement stmt) throws SSOIdentityException {
        block5: {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException se) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Error clossing statement");
                }
                throw new SSOIdentityException("Error while clossing statement: \n " + se.getMessage());
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug((Object)"Error clossing statement");
            }
        }
    }

    protected void closeResultSet(ResultSet result) throws SSOIdentityException {
        block5: {
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (SQLException se) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Error while clossing result set");
                }
                throw new SSOIdentityException("SQL Exception while closing\n" + se.getMessage());
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug((Object)"Error while clossing result set");
            }
        }
    }

    protected int countQueryVariables(String qry) {
        StringTokenizer st = new StringTokenizer(qry, "?", true);
        int count = 0;
        while (st.hasMoreTokens()) {
            String tk = st.nextToken();
            if (!"?".equals(tk)) continue;
            ++count;
        }
        return count;
    }
}

