/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.session.service.store.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.session.exceptions.SSOSessionException;
import org.josso.gateway.session.service.BaseSession;
import org.josso.gateway.session.service.MutableBaseSession;
import org.josso.gateway.session.service.store.AbstractSessionStore;

public abstract class DbSessionStore
extends AbstractSessionStore {
    private static final Log __log = LogFactory.getLog(DbSessionStore.class);
    private String _sizeQuery = null;
    private String _keysQuery = null;
    private String _loadAllQuery = null;
    private String _loadQuery = null;
    private String _loadByUserNameQuery = null;
    private String _loadByLastAccessTimeQuery = null;
    private String _loadByValidQuery = null;
    private String _deleteDml = null;
    private String _deleteAllDml = null;
    private String _insertDml = null;
    private String _updateDml = null;

    protected abstract Connection getConnection() throws SQLException, SSOSessionException;

    protected void close(Connection dbConnection) throws SSOSessionException {
        try {
            if (dbConnection != null && !dbConnection.isClosed()) {
                dbConnection.close();
            }
        }
        catch (SQLException se) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)"Error while clossing connection");
            }
            throw new SSOSessionException("Error while clossing connection\n" + se.getMessage());
        }
        catch (Exception e) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)"Error while clossing connection");
            }
            throw new SSOSessionException("Error while clossing connection\n" + e.getMessage());
        }
    }

    protected void close(Statement statement) throws SSOSessionException {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException se) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)"Error while clossing statement");
            }
            throw new SSOSessionException("Error while clossing statement\n" + se.getMessage());
        }
        catch (Exception e) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)"Error while clossing statement");
            }
            throw new SSOSessionException("Error while clossing statement\n" + e.getMessage());
        }
    }

    public void setInsertDml(String query) {
        this._insertDml = query;
    }

    public String getInsertDml() {
        return this._insertDml;
    }

    public void setUpdateDml(String query) {
        this._updateDml = query;
    }

    public String getUpdateDml() {
        return this._updateDml;
    }

    public void setDeleteAllDml(String query) {
        this._deleteAllDml = query;
    }

    public String getDeleteAllDml() {
        return this._deleteAllDml;
    }

    public void setDeleteDml(String query) {
        this._deleteDml = query;
    }

    public String getDeleteDml() {
        return this._deleteDml;
    }

    public void setLoadByLastAccessTimeQuery(String query) {
        this._loadByLastAccessTimeQuery = query;
    }

    public String getLoadByLastAccessTimeQuery() {
        return this._loadByLastAccessTimeQuery;
    }

    public void setLoadByValidQuery(String query) {
        this._loadByValidQuery = query;
    }

    public String getLoadByValidQuery() {
        return this._loadByValidQuery;
    }

    public void setLoadByUserNameQuery(String query) {
        this._loadByUserNameQuery = query;
    }

    public String getLoadByUserNameQuery() {
        return this._loadByUserNameQuery;
    }

    public void setSizeQuery(String query) {
        this._sizeQuery = query;
    }

    public String getSizeQuery() {
        return this._sizeQuery;
    }

    public void setKeysQuery(String query) {
        this._keysQuery = query;
    }

    public String getKeysQuery() {
        return this._keysQuery;
    }

    public void setLoadAllQuery(String query) {
        this._loadAllQuery = query;
    }

    public String getLoadAllQuery() {
        return this._loadAllQuery;
    }

    public void setLoadQuery(String query) {
        this._loadQuery = query;
    }

    public String getLoadQuery() {
        return this._loadQuery;
    }

    public int getSize() throws SSOSessionException {
        int retval = 0;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getConnection();
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(this._sizeQuery);
            if (rs != null && rs.next()) {
                retval = rs.getInt(1);
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e) {
            try {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)e, (Throwable)e);
                }
                throw new SSOSessionException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.close(conn);
                throw throwable;
            }
        }
        this.close(stmt);
        this.close(conn);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Returning " + retval));
        }
        return retval;
    }

    public String[] keys() throws SSOSessionException {
        String[] retval = null;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getConnection();
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(this._keysQuery);
            ArrayList<String> bucket = new ArrayList<String>();
            while (rs.next()) {
                bucket.add(rs.getString(1));
            }
            rs.close();
            retval = new String[bucket.size()];
            bucket.toArray(retval);
        }
        catch (Exception e) {
            try {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)e, (Throwable)e);
                }
                throw new SSOSessionException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.close(conn);
                throw throwable;
            }
        }
        this.close(stmt);
        this.close(conn);
        return retval;
    }

    public BaseSession[] loadAll() throws SSOSessionException {
        BaseSession[] retval = null;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getConnection();
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(this._loadAllQuery);
            retval = this.getSessions(rs);
            rs.close();
        }
        catch (Exception e) {
            try {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)e, (Throwable)e);
                }
                throw new SSOSessionException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.close(conn);
                throw throwable;
            }
        }
        this.close(stmt);
        this.close(conn);
        return retval;
    }

    public BaseSession load(String id) throws SSOSessionException {
        BaseSession retval = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(this._loadQuery);
            stmt.setString(1, id);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                retval = this.createFromResultSet(rs);
            }
            rs.close();
        }
        catch (Exception e) {
            try {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)e, (Throwable)e);
                }
                throw new SSOSessionException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.close(conn);
                throw throwable;
            }
        }
        this.close(stmt);
        this.close(conn);
        String string = id = retval == null ? "NOT FOUND" : retval.getId();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Loaded session: " + id));
        }
        return retval;
    }

    public BaseSession[] loadByUsername(String userName) throws SSOSessionException {
        BaseSession[] retval = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(this._loadByUserNameQuery);
            stmt.setString(1, userName);
            ResultSet rs = stmt.executeQuery();
            retval = this.getSessions(rs);
            rs.close();
        }
        catch (Exception e) {
            try {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)e, (Throwable)e);
                }
                throw new SSOSessionException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.close(conn);
                throw throwable;
            }
        }
        this.close(stmt);
        this.close(conn);
        return retval;
    }

    public BaseSession[] loadByLastAccessTime(Date date) throws SSOSessionException {
        BaseSession[] retval = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(this._loadByLastAccessTimeQuery);
            stmt.setLong(1, date.getTime());
            ResultSet rs = stmt.executeQuery();
            retval = this.getSessions(rs);
            rs.close();
        }
        catch (Exception e) {
            try {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)e, (Throwable)e);
                }
                throw new SSOSessionException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.close(conn);
                throw throwable;
            }
        }
        this.close(stmt);
        this.close(conn);
        return retval;
    }

    public BaseSession[] loadByValid(boolean valid) throws SSOSessionException {
        BaseSession[] retval = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(this._loadByValidQuery);
            stmt.setBoolean(1, valid);
            ResultSet rs = stmt.executeQuery();
            retval = this.getSessions(rs);
            rs.close();
        }
        catch (Exception e) {
            try {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)e, (Throwable)e);
                }
                throw new SSOSessionException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.close(conn);
                throw throwable;
            }
        }
        this.close(stmt);
        this.close(conn);
        return retval;
    }

    public void remove(String id) throws SSOSessionException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            this.delete(conn, id);
            conn.commit();
        }
        catch (Exception e) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)e, (Throwable)e);
            }
            throw new SSOSessionException((Throwable)e);
        }
        finally {
            this.close(conn);
        }
    }

    public void clear() throws SSOSessionException {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getConnection();
            stmt = conn.createStatement();
            stmt.execute(this._deleteAllDml);
            conn.commit();
        }
        catch (Exception e) {
            try {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)e, (Throwable)e);
                }
                throw new SSOSessionException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.close(conn);
                throw throwable;
            }
        }
        this.close(stmt);
        this.close(conn);
    }

    public void save(BaseSession session) throws SSOSessionException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            if (this.load(session.getId()) != null) {
                this.update(conn, session);
            } else {
                this.insert(conn, session);
            }
            conn.commit();
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Session committed: " + session.getId()));
            }
        }
        catch (Exception e) {
            block14: {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)e, (Throwable)e);
                }
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException sqle) {
                        if (!__log.isDebugEnabled()) break block14;
                        __log.debug((Object)"Error during ROLLBACK ", (Throwable)sqle);
                    }
                }
            }
            throw new SSOSessionException((Throwable)e);
        }
        finally {
            this.close(conn);
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Saved session: " + session.getId()));
        }
    }

    protected void delete(Connection conn, String sessionId) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(this._deleteDml);
        ps.setString(1, sessionId);
        ps.execute();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Session Removed: " + sessionId));
        }
    }

    protected void insert(Connection conn, BaseSession session) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(this._insertDml);
        ps.setString(1, session.getId());
        ps.setString(2, session.getUsername());
        ps.setLong(3, session.getCreationTime());
        ps.setLong(4, session.getLastAccessTime());
        ps.setInt(5, (int)session.getAccessCount());
        ps.setInt(6, session.getMaxInactiveInterval());
        ps.setBoolean(7, session.isValid());
        ps.execute();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Creation, LastAccess: " + session.getCreationTime() + ", " + session.getCreationTime()));
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Session inserted: " + session.getId()));
        }
    }

    protected void update(Connection conn, BaseSession session) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(this._updateDml);
        ps.setString(1, session.getUsername());
        ps.setLong(2, session.getCreationTime());
        ps.setLong(3, session.getLastAccessTime());
        ps.setInt(4, (int)session.getAccessCount());
        ps.setInt(5, session.getMaxInactiveInterval());
        ps.setBoolean(6, session.isValid());
        ps.setString(7, session.getId());
        ps.execute();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Creation, LastAccess: " + session.getCreationTime() + ", " + session.getCreationTime()));
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Session updated: " + session.getId()));
        }
    }

    protected BaseSession[] getSessions(ResultSet rs) throws SQLException {
        ArrayList<BaseSession> bucket = new ArrayList<BaseSession>();
        while (rs.next()) {
            bucket.add(this.createFromResultSet(rs));
        }
        BaseSession[] retval = new BaseSession[bucket.size()];
        bucket.toArray(retval);
        return retval;
    }

    protected BaseSession createFromResultSet(ResultSet rs) throws SQLException {
        MutableBaseSession bsi = new MutableBaseSession();
        bsi.setId(rs.getString(1));
        bsi.setUsername(rs.getString(2));
        bsi.setCreationTime(rs.getLong(3));
        bsi.setLastAccessedTime(rs.getLong(4));
        bsi.setAccessCount(rs.getLong(5));
        bsi.setMaxInactiveInterval(rs.getInt(6));
        bsi.setValid(rs.getBoolean(7));
        return bsi;
    }
}

