/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.assertion.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.assertion.service.AssertionIdGenerator;
import org.josso.util.id.AbstractIdGenerator;

public class AssertionIdGeneratorImpl
extends AbstractIdGenerator
implements AssertionIdGenerator {
    private static final Log logger = LogFactory.getLog(AssertionIdGeneratorImpl.class);
    private int assertionIdLength = 8;

    public synchronized String generateId() {
        byte[] random = new byte[16];
        StringBuffer result = new StringBuffer();
        int resultLenBytes = 0;
        while (resultLenBytes < this.assertionIdLength) {
            this.getRandomBytes(random);
            random = this.getDigest().digest(random);
            for (int j = 0; j < random.length && resultLenBytes < this.assertionIdLength; ++resultLenBytes, ++j) {
                byte b1 = (byte)((random[j] & 0xF0) >> 4);
                byte b2 = (byte)(random[j] & 0xF);
                if (b1 < 10) {
                    result.append((char)(48 + b1));
                } else {
                    result.append((char)(65 + (b1 - 10)));
                }
                if (b2 < 10) {
                    result.append((char)(48 + b2));
                    continue;
                }
                result.append((char)(65 + (b2 - 10)));
            }
        }
        return result.toString();
    }
}

