/*
 * Decompiled with CFR 0.152.
 */
package org.josso.auth;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.auth.Authenticator;
import org.josso.auth.Credential;
import org.josso.auth.exceptions.AuthenticationFailureException;
import org.josso.auth.exceptions.SSOAuthenticationException;
import org.josso.auth.scheme.AuthenticationScheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticatorImpl
implements Authenticator {
    private static final Log logger = LogFactory.getLog(AuthenticatorImpl.class);
    private long _authCount;
    private long _authFailures;
    private List<AuthenticationScheme> _as;

    public Subject check(Credential[] credentials, String schemeName) throws SSOAuthenticationException {
        Subject s = new Subject();
        AuthenticationScheme scheme = this.getScheme(schemeName);
        scheme.initialize(credentials, s);
        if (scheme.authenticate()) {
            scheme.confirm();
            ++this._authCount;
        } else {
            scheme.cancel();
            ++this._authFailures;
            throw new AuthenticationFailureException(scheme.getPrincipal().getName());
        }
        return s;
    }

    public Credential newCredential(String schemeName, String name, Object value) throws SSOAuthenticationException {
        return this.getScheme(schemeName).newCredential(name, value);
    }

    public Principal getPrincipal(String schemeName, Credential[] credentials) {
        return this.getScheme(schemeName).getPrincipal(credentials);
    }

    public void setAuthenticationSchemes(AuthenticationScheme[] as) {
        this._as = new ArrayList<AuthenticationScheme>();
        for (int i = 0; i < as.length; ++i) {
            AuthenticationScheme a = as[i];
            logger.info((Object)("[setAuthenticationScheme()] : " + a.getName() + "," + a.getClass().getName()));
            this._as.add(a);
        }
    }

    public AuthenticationScheme[] getAuthenticationSchemes() {
        return this._as.toArray(new AuthenticationScheme[this._as.size()]);
    }

    public AuthenticationScheme getAuthenticationScheme(String name) {
        return this.getScheme(name);
    }

    public List<AuthenticationScheme> getSchemes() {
        return this._as;
    }

    public void setSchemes(List<AuthenticationScheme> schemes) {
        this._as = schemes;
    }

    public long getAuthCount() {
        return this._authCount;
    }

    public long getAuthFailures() {
        return this._authFailures;
    }

    public List<String> getSchemeNames() {
        ArrayList<String> names = new ArrayList<String>(this._as.size());
        for (AuthenticationScheme s : this._as) {
            names.add(s.getName());
        }
        return names;
    }

    protected AuthenticationScheme getScheme(String schemeName) {
        for (int i = 0; i < this._as.size(); ++i) {
            AuthenticationScheme a = this._as.get(i);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getScheme() : checking " + a.getName()));
            }
            if (!a.getName().equals(schemeName)) continue;
            return (AuthenticationScheme)a.clone();
        }
        logger.warn((Object)("Authentication scheme [" + schemeName + "] not registered!"));
        return null;
    }
}

