/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.event.security;

import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.Registry;
import org.josso.gateway.event.SSOEvent;
import org.josso.gateway.event.SSOEventListener;
import org.josso.gateway.event.security.NotificationSSOEventListener;
import org.josso.gateway.event.security.SSOEventNotification;
import org.josso.gateway.event.security.SSOSecurityEventManagerImpl;

public class JMXSSOEventManagerImpl
extends SSOSecurityEventManagerImpl {
    public static final Log logger = LogFactory.getLog(JMXSSOEventManagerImpl.class);
    private static long sequnece;
    private ObjectName mbeanOname;
    private String oname;
    private boolean initialized = false;
    private List preRegistered;
    private Registry registry = Registry.getRegistry(null, null);

    public JMXSSOEventManagerImpl() {
        this.preRegistered = new ArrayList();
    }

    public void initialize() {
        super.initialize();
        if (this.initialized) {
            return;
        }
        try {
            this.mbeanOname = new ObjectName(this.oname);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Using MBean for notifications : " + this.mbeanOname));
            }
            this.initialized = true;
            for (int i = 0; i < this.preRegistered.size(); ++i) {
                SSOEventListener listener = (SSOEventListener)this.preRegistered.get(i);
                this.registerListener(listener);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Can't create MBean Objectname : " + e.getMessage()), (Throwable)e);
        }
    }

    public void destroy() {
        super.destroy();
    }

    public void fireSSOEvent(SSOEvent event) {
        try {
            MBeanServer server = this.getMBeanServer();
            Notification notification = this.buildNotification(event);
            server.invoke(this.mbeanOname, "fireJMXSSOEvent", new Object[]{notification}, new String[]{"javax.management.Notification"});
        }
        catch (Exception e) {
            logger.error((Object)("Can't send SSO Event : " + e.getMessage()), (Throwable)e);
        }
    }

    public void registerListener(SSOEventListener listener) {
        if (!this.initialized) {
            this.preRegistered.add(listener);
            return;
        }
        try {
            logger.info((Object)("Adding listener : " + listener + " for : " + this.mbeanOname));
            this.getMBeanServer().addNotificationListener(this.mbeanOname, new NotificationSSOEventListener(listener), null, null);
        }
        catch (Exception e) {
            logger.error((Object)("Can't add listener : " + listener + " to mbean : " + this.mbeanOname + "\n" + e.getMessage()), (Throwable)e);
        }
    }

    public String getOname() {
        return this.oname;
    }

    public void setOname(String oname) {
        this.oname = oname;
    }

    protected MBeanServer getMBeanServer() {
        return this.registry.getMBeanServer();
    }

    protected Notification buildNotification(SSOEvent event) {
        return new SSOEventNotification(event, sequnece++);
    }
}

