/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.event.security;

import java.util.EventObject;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.SSOConfigurationEventListener;
import org.josso.gateway.event.SSOEvent;
import org.josso.gateway.event.SSOEventListener;
import org.josso.gateway.event.security.SSOEventNotification;
import org.josso.gateway.event.security.SSOSecurityEventManagerImpl;
import org.springframework.jmx.export.notification.NotificationPublisher;
import org.springframework.jmx.export.notification.NotificationPublisherAware;

public class SpringJMXSSOEventManagerImpl
extends SSOSecurityEventManagerImpl
implements NotificationPublisherAware,
NotificationListener {
    public static final Log logger = LogFactory.getLog(SpringJMXSSOEventManagerImpl.class);
    private NotificationPublisher publisher;
    private static long sequnece;

    protected Notification buildNotification(SSOEvent event) {
        return new SSOEventNotification(event, sequnece++);
    }

    public void fireSSOEvent(SSOEvent event) {
        try {
            this.publisher.sendNotification(this.buildNotification(event));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sent notification : " + event));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Can't send JMX Notification : " + e.getMessage()), (Throwable)e);
        }
    }

    public void setNotificationPublisher(NotificationPublisher notificationPublisher) {
        this.publisher = notificationPublisher;
    }

    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof SSOEventNotification) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received SSO Event Notification  : " + notification.getType()));
            }
            if (this.getListeners().size() < 1) {
                logger.warn((Object)"No listeners registered!");
            }
            try {
                String eventType = notification.getType();
                for (SSOEventListener l : this.getListeners()) {
                    if (l instanceof SSOConfigurationEventListener) {
                        SSOConfigurationEventListener listener = (SSOConfigurationEventListener)l;
                        if (!listener.isEventEnabled(eventType, (EventObject)notification)) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Handling notification to configuration listener : " + l));
                        }
                        listener.handleEvent(eventType, (EventObject)notification);
                        continue;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Handling notification to listener : " + l));
                    }
                    l.handleSSOEvent(((SSOEventNotification)notification).getEvent());
                }
            }
            catch (Exception e) {
                logger.error((Object)("Can't handle notification " + notification + ": \n" + e.getMessage()), (Throwable)e);
            }
        }
    }
}

