/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.identity.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.Lookup;
import org.josso.auth.Credential;
import org.josso.gateway.identity.SSORole;
import org.josso.gateway.identity.SSOUser;
import org.josso.gateway.identity.exceptions.NoSuchUserException;
import org.josso.gateway.identity.exceptions.SSOIdentityException;
import org.josso.gateway.identity.service.BaseUser;
import org.josso.gateway.identity.service.SSOIdentityManager;
import org.josso.gateway.identity.service.store.ExtendedIdentityStore;
import org.josso.gateway.identity.service.store.IdentityStore;
import org.josso.gateway.identity.service.store.IdentityStoreKeyAdapter;
import org.josso.gateway.identity.service.store.SimpleUserKey;
import org.josso.gateway.identity.service.store.UserKey;
import org.josso.gateway.session.exceptions.NoSuchSessionException;
import org.josso.gateway.session.exceptions.SSOSessionException;
import org.josso.gateway.session.service.BaseSession;
import org.josso.gateway.session.service.SSOSessionManager;
import org.josso.selfservices.ChallengeResponseCredential;

public class SSOIdentityManagerImpl
implements SSOIdentityManager {
    private static final Log logger = LogFactory.getLog(SSOIdentityManagerImpl.class);
    private IdentityStore _store;
    private IdentityStoreKeyAdapter _keyAdapter;
    private SSOSessionManager _sessionManager;

    public SSOUser findUser(String name) throws NoSuchUserException, SSOIdentityException {
        UserKey key = this.getIdentityStoreKeyAdapter().getKeyForUsername(name);
        BaseUser user = this.getIdentityStore().loadUser(key);
        if (user == null) {
            throw new NoSuchUserException(key);
        }
        return user;
    }

    public SSOUser findUserInSession(String sessionId) throws SSOIdentityException {
        BaseUser user = null;
        SimpleUserKey key = null;
        try {
            BaseSession s = (BaseSession)this.getSessionManager().getSession(sessionId);
            key = new SimpleUserKey(s.getUsername());
            user = this.getIdentityStore().loadUser((UserKey)key);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[findUserInSession(" + sessionId + ")] Found :  " + user));
            }
            return user;
        }
        catch (NoSuchSessionException e) {
            throw new SSOIdentityException("Invalid session : " + sessionId);
        }
        catch (SSOSessionException e) {
            throw new SSOIdentityException(e.getMessage(), (Throwable)e);
        }
    }

    public SSORole[] findRolesByUsername(String username) throws SSOIdentityException {
        UserKey key = this.getIdentityStoreKeyAdapter().getKeyForUsername(username);
        return this.getIdentityStore().findRolesByUserKey(key);
    }

    public void userExists(String username) throws NoSuchUserException, SSOIdentityException {
        UserKey key = this.getIdentityStoreKeyAdapter().getKeyForUsername(username);
        if (!this.getIdentityStore().userExists(key)) {
            throw new NoSuchUserException(key);
        }
    }

    public void updateAccountPassword(SSOUser user, Credential password) throws NoSuchUserException, SSOIdentityException {
        if (!(this._store instanceof ExtendedIdentityStore)) {
            throw new UnsupportedOperationException("The configured identity store implementatino does not support account update.");
        }
        UserKey key = this.getIdentityStoreKeyAdapter().getKeyForUsername(user.getName());
        ExtendedIdentityStore eStore = (ExtendedIdentityStore)this._store;
        eStore.updateAccountPassword(key, password);
    }

    public String findUsernameByRelayCredential(ChallengeResponseCredential relayCredential) throws SSOIdentityException {
        if (this._store instanceof ExtendedIdentityStore) {
            ExtendedIdentityStore eStore = (ExtendedIdentityStore)this._store;
            return eStore.loadUsernameByRelayCredential(relayCredential);
        }
        throw new UnsupportedOperationException("The configured identity store implementatino does not support account update.");
    }

    public void setIdentityStore(IdentityStore s) {
        this._store = s;
    }

    public void setIdentityStoreKeyAdapter(IdentityStoreKeyAdapter a) {
        this._keyAdapter = a;
    }

    public void initialize() {
    }

    protected IdentityStore getIdentityStore() {
        return this._store;
    }

    protected IdentityStoreKeyAdapter getIdentityStoreKeyAdapter() {
        return this._keyAdapter;
    }

    protected SSOSessionManager getSessionManager() {
        if (this._sessionManager == null) {
            try {
                this._sessionManager = Lookup.getInstance().lookupSecurityDomain().getSessionManager();
            }
            catch (Exception e) {
                logger.error((Object)("Can't find Session Manager : \n" + e.getMessage() != null ? e.getMessage() : e.toString()), (Throwable)e);
            }
        }
        return this._sessionManager;
    }
}

