/*
 * Decompiled with CFR 0.152.
 */
package org.josso.selfservices.password;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.SSOException;
import org.josso.selfservices.BaseProcessState;
import org.josso.selfservices.ProcessRequest;
import org.josso.selfservices.ProcessResponse;
import org.josso.selfservices.ProcessState;
import org.josso.selfservices.annotations.Action;
import org.josso.selfservices.annotations.Extension;
import org.josso.selfservices.password.PasswordManagementException;
import org.josso.selfservices.password.PasswordManagementProcess;
import org.josso.selfservices.password.PasswordManagementService;
import org.josso.util.id.IdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordManagementServiceImpl
implements PasswordManagementService {
    private static final Log log = LogFactory.getLog(PasswordManagementServiceImpl.class);
    private IdGenerator idGenerator;
    private Map<String, PasswordManagementProcess> prototypeProcesses = new HashMap<String, PasswordManagementProcess>();
    private Map<String, PasswordManagementProcess> runningProcesses = new HashMap<String, PasswordManagementProcess>();
    private PasswordManagementMonitor monitor;

    public void initialize() {
        this.monitor = new PasswordManagementMonitor(this);
        Thread t = new Thread(this.monitor);
        t.setName("JOSSOPasswordManagementMonitor");
        t.start();
    }

    public ProcessResponse startProcess(String name) throws SSOException {
        String id = this.idGenerator.generateId();
        PasswordManagementProcess p = this.getPrototype(name);
        if (p == null) {
            throw new SSOException("No such process : " + name);
        }
        p = p.createNewProcess(id);
        this.runningProcesses.put(p.getProcessId(), p);
        ProcessResponse r = p.start();
        ((BaseProcessState)p.getState()).setNextStep(r.getNextStep());
        return r;
    }

    public ProcessResponse handleRequest(ProcessRequest request) throws PasswordManagementException {
        String processId = request.getProcessId();
        String actionName = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Handling request for process [" + processId + "]"));
        }
        try {
            Method[] methods;
            PasswordManagementProcess p = this.runningProcesses.get(processId);
            if (p == null) {
                throw new PasswordManagementException("No such process " + processId);
            }
            String nextStep = p.getState().getNextStep();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Handling request for process [" + processId + "]"));
            }
            for (Method method : methods = p.getClass().getMethods()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Processing method : " + method.getName()));
                }
                if (!method.isAnnotationPresent(Action.class)) continue;
                Action action = method.getAnnotation(Action.class);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Processing method annotation : " + action));
                }
                for (String actionStep : action.fromSteps()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Processing annotation step : " + actionStep));
                    }
                    if (!actionStep.equals(nextStep)) continue;
                    actionName = method.getName();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Dispatching request from step " + nextStep + " to process [" + processId + "] action " + actionName));
                    }
                    ProcessResponse r = (ProcessResponse)method.invoke((Object)p, request);
                    ((BaseProcessState)p.getState()).setNextStep(r.getNextStep());
                    return r;
                }
            }
            throw new PasswordManagementException("Step [" + nextStep + "] not supported by process");
        }
        catch (InvocationTargetException e) {
            throw new PasswordManagementException("Cannot invoke process action [" + actionName + "] : " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new PasswordManagementException("Cannot invoke process action [" + actionName + "] : " + e.getMessage(), (Throwable)e);
        }
    }

    public ProcessState getProcessState(String processId) {
        return this.runningProcesses.get(processId).getState();
    }

    public ProcessRequest createRequest(String processId) throws PasswordManagementException {
        PasswordManagementProcess p = this.runningProcesses.get(processId);
        if (p == null) {
            throw new PasswordManagementException("Invalid proces ID : " + processId);
        }
        return p.createRequest();
    }

    protected PasswordManagementProcess getPrototype(String name) {
        return this.prototypeProcesses.get(name);
    }

    public IdGenerator getProcessIdGenerator() {
        return this.idGenerator;
    }

    public void setProcessIdGenerator(IdGenerator idGen) {
        this.idGenerator = idGen;
    }

    public Collection<PasswordManagementProcess> getPrototypeProcesses() {
        return this.prototypeProcesses.values();
    }

    public void setPrototypeProcesses(Collection<PasswordManagementProcess> prototypeProcesses) {
        for (PasswordManagementProcess prototype : prototypeProcesses) {
            this.prototypeProcesses.put(prototype.getName(), prototype);
        }
    }

    public void checkPendingProcesses() {
        try {
            long now = System.currentTimeMillis();
            for (PasswordManagementProcess process : this.runningProcesses.values()) {
                try {
                    ArrayList<PasswordManagementProcess> toRemove = new ArrayList<PasswordManagementProcess>();
                    if (!process.isRunning() || process.getCreationTime() - now > (long)process.getMaxTimeToLive()) {
                        toRemove.add(process);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("[checkPendingProcesses()] Process expired : " + process.getProcessId()));
                        }
                    }
                    for (PasswordManagementProcess passwordManagementProcess : toRemove) {
                        try {
                            passwordManagementProcess.stop();
                        }
                        catch (Exception e) {
                            log.debug((Object)e.getMessage(), (Throwable)e);
                        }
                        this.runningProcesses.remove(passwordManagementProcess.getProcessId());
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("Can't remove process " + e.getMessage() != null ? e.getMessage() : e.toString()), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot check pending processes! " + e.getMessage()), (Throwable)e);
        }
    }

    public void register(String processId, String name, Object extension) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering " + name));
        }
        PasswordManagementProcess p = this.runningProcesses.get(processId);
        for (Class<?> clazz = p.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                Extension ex;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Checking field : " + field.getName()));
                }
                if (!field.isAnnotationPresent(Extension.class) || !(ex = field.getAnnotation(Extension.class)).value().equals(name)) continue;
                log.debug((Object)("Injecting extension : " + name));
                try {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    field.set(p, extension);
                    return;
                }
                catch (IllegalAccessException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private class PasswordManagementMonitor
    implements Runnable {
        private long _interval;
        private PasswordManagementService _m;

        PasswordManagementMonitor(PasswordManagementService m) {
            this._m = m;
        }

        PasswordManagementMonitor(PasswordManagementService m, long interval) {
            this._interval = interval;
            this._m = m;
        }

        public long getInterval() {
            return this._interval;
        }

        public void setInterval(long interval) {
            this._interval = interval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"[run()] calling checkPendingProcesses ... ");
                        }
                        this._m.checkPendingProcesses();
                        PasswordManagementMonitor passwordManagementMonitor = this;
                        synchronized (passwordManagementMonitor) {
                            try {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("[run()] waiting " + this._interval + " ms"));
                                }
                                this.wait(this._interval);
                            }
                            catch (InterruptedException e) {
                                log.warn((Object)e, (Throwable)e);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("Exception received : " + e.getMessage() != null ? e.getMessage() : e.toString()), (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

