/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.session.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.Lookup;
import org.josso.gateway.SecurityDomainRegistry;
import org.josso.gateway.session.SSOSession;
import org.josso.gateway.session.exceptions.NoSuchSessionException;
import org.josso.gateway.session.exceptions.SSOSessionException;
import org.josso.gateway.session.exceptions.TooManyOpenSessionsException;
import org.josso.gateway.session.service.BaseSession;
import org.josso.gateway.session.service.BaseSessionImpl;
import org.josso.gateway.session.service.SSOSessionManager;
import org.josso.gateway.session.service.SessionIdGenerator;
import org.josso.gateway.session.service.store.SessionStore;

public class SSOSessionManagerImpl
implements SSOSessionManager {
    private static final Log logger = LogFactory.getLog(SSOSessionManagerImpl.class);
    private int _maxInactiveInterval = 30;
    private int _maxSessionsPerUser = 1;
    private long _sessionMonitorInterval = 5000L;
    private boolean _invalidateExceedingSessions = false;
    private String _securityDomainName;
    private SessionStore _store;
    private SessionIdGenerator _idGen;
    private SessionMonitor _monitor;

    public void setSecurityDomainName(String securityDomainName) {
        this._securityDomainName = securityDomainName;
    }

    public synchronized void initialize() {
        logger.info((Object)("[initialize()] : IdGenerator.................=" + this._idGen.getClass().getName()));
        logger.info((Object)("[initialize()] : Store.......................=" + this._store.getClass().getName()));
        logger.info((Object)("[initialize()] : MaxInactive.................=" + this._maxInactiveInterval));
        logger.info((Object)("[initialize()] : MaxSessionsPerUser..........=" + this._maxSessionsPerUser));
        logger.info((Object)("[initialize()] : InvalidateExceedingSessions.=" + this._invalidateExceedingSessions));
        logger.info((Object)("[initialize()] : SesisonMonitorInteval.......=" + this._sessionMonitorInterval));
        this._monitor = new SessionMonitor(this, this.getSessionMonitorInterval());
        Thread t = new Thread(this._monitor);
        t.setDaemon(true);
        t.setName("JOSSOSessionMonitor");
        t.start();
        logger.info((Object)("[initialize()] : Restore Sec.Domain Registry.=" + this._securityDomainName));
        try {
            SecurityDomainRegistry registry = Lookup.getInstance().lookupSecurityDomainRegistry();
            BaseSession[] sessions = this._store.loadAll();
            for (int i = 0; i < sessions.length; ++i) {
                BaseSession session = sessions[i];
                registry.registerToken(this._securityDomainName, TOKEN_TYPE, session.getId());
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String initiateSession(String username) throws SSOSessionException {
        BaseSession[] sessions = this._store.loadByUsername(username);
        if (!this._invalidateExceedingSessions && this._maxSessionsPerUser != -1 && this._maxSessionsPerUser <= sessions.length) {
            throw new TooManyOpenSessionsException(sessions.length);
        }
        if (this._invalidateExceedingSessions && this._maxSessionsPerUser != -1) {
            int invalidate = sessions.length - this._maxSessionsPerUser + 1;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Auto-invalidating " + invalidate + " sessions for user : " + username));
            }
            int idx = 0;
            while (invalidate > 0) {
                BaseSession session = sessions[idx];
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Auto-invalidating " + session.getId() + " session for user : " + username));
                }
                this.invalidate(session.getId());
                --invalidate;
            }
        }
        BaseSession session = this.doMakeNewSession();
        session.setId(this._idGen.generateId());
        session.setCreationTime(System.currentTimeMillis());
        session.setValid(true);
        session.setMaxInactiveInterval(this.getMaxInactiveInterval() * 60);
        session.setUsername(username);
        this._store.save(session);
        try {
            SecurityDomainRegistry registry = Lookup.getInstance().lookupSecurityDomainRegistry();
            registry.registerToken(this._securityDomainName, TOKEN_TYPE, session.getId());
        }
        catch (Exception e) {
            throw new SSOSessionException(e.getMessage(), (Throwable)e);
        }
        session.fireSessionEvent("createSession", null);
        return session.getId();
    }

    public SSOSession getSession(String sessionId) throws NoSuchSessionException, SSOSessionException {
        BaseSession s = this._store.load(sessionId);
        if (s == null) {
            throw new NoSuchSessionException(sessionId);
        }
        return s;
    }

    public Collection getSessions() throws SSOSessionException {
        return Arrays.asList(this._store.loadAll());
    }

    public Collection getUserSessions(String username) throws NoSuchSessionException, SSOSessionException {
        BaseSession[] s = this._store.loadByUsername(username);
        if (s.length < 1) {
            throw new NoSuchSessionException(username);
        }
        ArrayList<BaseSession> result = new ArrayList<BaseSession>(s.length);
        for (int i = 0; i < s.length; ++i) {
            result.add(s[i]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accessSession(String sessionId) throws NoSuchSessionException, SSOSessionException {
        try {
            BaseSession s;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[accessSession()] trying session : " + sessionId));
            }
            if (!(s = (BaseSession)this.getSession(sessionId)).isValid()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[accessSession()] invalid session : " + sessionId));
                }
                throw new NoSuchSessionException(sessionId);
            }
            s.access();
            this._store.save(s);
            try {
                SecurityDomainRegistry registry = Lookup.getInstance().lookupSecurityDomainRegistry();
                registry.registerToken(this._securityDomainName, TOKEN_TYPE, s.getId());
            }
            catch (Exception e) {
                throw new SSOSessionException(e.getMessage(), (Throwable)e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"[accessSession()] ok");
            }
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[accessSession()] ended for session : " + sessionId));
            }
        }
    }

    public void invalidateAll() throws SSOSessionException {
        BaseSession[] sessions = this._store.loadAll();
        for (int i = 0; i < sessions.length; ++i) {
            BaseSession session = sessions[i];
            session.expire();
        }
    }

    public void invalidate(String sessionId) throws NoSuchSessionException, SSOSessionException {
        BaseSession s = (BaseSession)this.getSession(sessionId);
        try {
            this._store.remove(sessionId);
            SecurityDomainRegistry registry = Lookup.getInstance().lookupSecurityDomainRegistry();
            registry.unregisterToken(this._securityDomainName, TOKEN_TYPE, sessionId);
        }
        catch (SSOSessionException e) {
            logger.warn((Object)("Can't remove session from store\n" + e.getMessage() != null ? e.getMessage() : e.toString()), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("Can't remove session from store\n" + e.getMessage() != null ? e.getMessage() : e.toString()), (Throwable)e);
        }
        s.expire();
    }

    public void checkValidSessions() {
        try {
            BaseSession[] sessions = this._store.loadByValid(false);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[checkValidSessions()] found " + sessions.length + " invalid sessions"));
            }
            this.checkValidSessions(sessions);
            long period = (long)this._maxInactiveInterval * 60L * 1000L;
            Date from = new Date(System.currentTimeMillis() - period);
            sessions = this._store.loadByLastAccessTime(from);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[checkValidSessions()] found " + sessions.length + " sessions last accessed before " + from));
            }
            this.checkValidSessions(sessions);
        }
        catch (Exception e) {
            logger.error((Object)("Can't process expired sessions : " + e.getMessage()), (Throwable)e);
        }
    }

    protected void checkValidSessions(BaseSession[] sessions) {
        for (int i = 0; i < sessions.length; ++i) {
            try {
                BaseSession session = sessions[i];
                if (session.isValid()) continue;
                this._store.remove(session.getId());
                SecurityDomainRegistry registry = Lookup.getInstance().lookupSecurityDomainRegistry();
                registry.unregisterToken(this._securityDomainName, TOKEN_TYPE, session.getId());
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("[checkValidSessions()] Session expired : " + session.getId()));
                continue;
            }
            catch (Exception e) {
                logger.warn((Object)("Can't remove session [" + i + "]; " + e.getMessage() != null ? e.getMessage() : e.toString()), (Throwable)e);
            }
        }
    }

    public void setSessionStore(SessionStore ss) {
        this._store = ss;
    }

    public void setSessionIdGenerator(SessionIdGenerator g) {
        this._idGen = g;
    }

    public int getSessionCount() throws SSOSessionException {
        return this._store.getSize();
    }

    public int getMaxInactiveInterval() {
        return this._maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this._maxInactiveInterval = maxInactiveInterval;
    }

    public int getMaxSessionsPerUser() {
        return this._maxSessionsPerUser;
    }

    public void setMaxSessionsPerUser(int maxSessionsPerUser) {
        this._maxSessionsPerUser = maxSessionsPerUser;
    }

    public boolean isInvalidateExceedingSessions() {
        return this._invalidateExceedingSessions;
    }

    public void setInvalidateExceedingSessions(boolean invalidateExceedingSessions) {
        this._invalidateExceedingSessions = invalidateExceedingSessions;
    }

    public long getSessionMonitorInterval() {
        return this._sessionMonitorInterval;
    }

    public void setSessionMonitorInterval(long sessionMonitorInterval) {
        this._sessionMonitorInterval = sessionMonitorInterval;
        if (this._monitor != null) {
            this._monitor.setInterval(this._sessionMonitorInterval);
        }
    }

    protected BaseSession doMakeNewSession() {
        return new BaseSessionImpl();
    }

    private class SessionMonitor
    implements Runnable {
        private long _interval;
        private SSOSessionManager _m;

        SessionMonitor(SSOSessionManager m) {
            this._m = m;
        }

        SessionMonitor(SSOSessionManager m, long interval) {
            this._interval = interval;
            this._m = m;
        }

        public long getInterval() {
            return this._interval;
        }

        public void setInterval(long interval) {
            this._interval = interval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"[run()] calling checkValidSessions ... ");
                        }
                        this._m.checkValidSessions();
                        SessionMonitor sessionMonitor = this;
                        synchronized (sessionMonitor) {
                            try {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("[run()] waiting " + this._interval + " ms"));
                                }
                                this.wait(this._interval);
                            }
                            catch (InterruptedException e) {
                                logger.warn((Object)e, (Throwable)e);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("Exception received : " + e.getMessage() != null ? e.getMessage() : e.toString()), (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

