/*
 * Decompiled with CFR 0.152.
 */
package org.josso.selfservices.password;

import java.io.StringWriter;
import java.io.Writer;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.josso.gateway.SSONameValuePair;
import org.josso.gateway.identity.SSOUser;
import org.josso.selfservices.ProcessState;
import org.josso.selfservices.password.PasswordDistributor;
import org.josso.selfservices.password.PasswordManagementException;
import org.josso.selfservices.password.lostpassword.LostPasswordProcessState;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessagePreparator;

public class EMailPasswordDistributor
implements PasswordDistributor {
    private static final Log logger = LogFactory.getLog(EMailPasswordDistributor.class);
    private JavaMailSender mailSender;
    private String mailFrom;
    private String mailSubject;
    private String template;
    private String mailToUserProperty;

    public void distributePassword(SSOUser user, String clearPassword, ProcessState state) throws PasswordManagementException {
        SSONameValuePair[] props;
        assert (this.mailToUserProperty != null) : "'mailToUserProperty' must be configured!";
        String mailTo = null;
        for (SSONameValuePair prop : props = user.getProperties()) {
            if (!prop.getName().equals(this.mailToUserProperty)) continue;
            mailTo = prop.getValue();
        }
        if (mailTo == null) {
            throw new PasswordManagementException("User property '" + this.mailToUserProperty + "' not found in SSOUser !");
        }
        String mailText = this.createMessageBody(user, clearPassword, state);
        this.sendMail(mailTo, this.mailFrom, mailText);
    }

    protected void sendMail(final String mailTo, final String mailFrom, final String text) throws PasswordManagementException {
        MimeMessagePreparator preparator = new MimeMessagePreparator(){

            public void prepare(MimeMessage mimeMessage) throws Exception {
                mimeMessage.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(mailTo));
                mimeMessage.setFrom((Address)new InternetAddress(mailFrom));
                mimeMessage.setSubject(EMailPasswordDistributor.this.getMailSubject());
                mimeMessage.setText(text);
            }
        };
        try {
            this.mailSender.send(preparator);
        }
        catch (MailException e) {
            throw new PasswordManagementException("Cannot distribute password to [" + mailTo + "] " + e.getMessage(), (Throwable)e);
        }
    }

    protected String createMessageBody(SSOUser user, String clearPassword, ProcessState state) throws PasswordManagementException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating email body with Velocity template : " + this.getTemplate()));
            }
            String url = ((LostPasswordProcessState)state).getPasswordConfirmUrl();
            assert (url == null) : "No password confirmation url found in process state, attribute:'passwordConfirmUrl'";
            VelocityEngine ve = new VelocityEngine();
            ve.setProperty("runtime.log.logsystem", (Object)logger);
            ve.setProperty("resource.loader", (Object)"class");
            ve.setProperty("class.resource.loader.description", (Object)"Velocity Classpath Resource Loader");
            ve.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            ve.init();
            VelocityContext ctx = new VelocityContext();
            ctx.put("jossoUser", (Object)user);
            ctx.put("jossoClearPassword", (Object)clearPassword);
            ctx.put("jossoProcessState", (Object)state);
            ctx.put("jossoConfirmUrl", (Object)url);
            Template template = ve.getTemplate(this.template);
            StringWriter w = new StringWriter(4096);
            template.merge((Context)ctx, (Writer)w);
            w.flush();
            return w.getBuffer().toString();
        }
        catch (ParseErrorException e) {
            throw new PasswordManagementException("Cannot generate e-mail : " + e.getMessage(), (Throwable)e);
        }
        catch (ResourceNotFoundException e) {
            throw new PasswordManagementException("Cannot generate e-mail : " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new PasswordManagementException("Cannot generate e-mail : " + e.getMessage(), (Throwable)e);
        }
    }

    public JavaMailSender getMailSender() {
        return this.mailSender;
    }

    public void setMailSender(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    public String getMailFrom() {
        return this.mailFrom;
    }

    public void setMailFrom(String mailFrom) {
        this.mailFrom = mailFrom;
    }

    public String getMailSubject() {
        return this.mailSubject;
    }

    public void setMailSubject(String mailSubject) {
        this.mailSubject = mailSubject;
    }

    public String getMailToUserProperty() {
        return this.mailToUserProperty;
    }

    public void setMailToUserProperty(String mailToUserProperty) {
        this.mailToUserProperty = mailToUserProperty;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String velocityTemplate) {
        this.template = velocityTemplate;
    }
}

