/*
 * Decompiled with CFR 0.152.
 */
package org.josso.jb32.agent;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import org.apache.catalina.Realm;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.naming.Util;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.SubjectSecurityManager;
import org.jboss.security.plugins.JaasSecurityManager;
import org.jboss.web.tomcat.security.JBossSecurityMgrRealm;
import org.jboss.web.tomcat.security.SecurityAssociationValve;
import org.josso.agent.AbstractSSOAgent;
import org.josso.agent.Lookup;
import org.josso.agent.SSOAgentRequest;
import org.josso.gateway.identity.SSORole;
import org.josso.gateway.identity.SSOUser;
import org.josso.gateway.identity.exceptions.SSOIdentityException;
import org.josso.gateway.identity.service.BaseRoleImpl;
import org.josso.gateway.identity.service.SSOIdentityManagerService;
import org.josso.jb32.agent.JBossSecurityAssociationActions;
import org.josso.tc50.agent.jaas.CatalinaSSOUser;

public class JBossCatalinaNativeRealm
extends JBossSecurityMgrRealm {
    private static final Log logger = LogFactory.getLog(JBossCatalinaNativeRealm.class);
    private static final String JOSSO_SECURITY_DOMAIN = "java:/jaas/josso";
    private static final String DEFAULT_CACHE_POLICY_PATH = "java:/timedCacheFactory";
    private static String cacheJndiName = "java:/timedCacheFactory";
    private HashMap _userPrincipalMap = new HashMap();

    protected boolean isSSODomain(String domain) {
        boolean isSSODomain = "josso".equals(domain);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(" JBoss Security Domain [" + domain + "] is" + (isSSODomain ? "" : " not") + " under SSO Control"));
        }
        return isSSODomain;
    }

    public Principal authenticate(String username, String credentials) {
        logger.debug((Object)("Begin authenticate, username=" + username));
        Object principal = null;
        SSOUser ssoUser = null;
        Principal caller = (Principal)SecurityAssociationValve.userPrincipal.get();
        if (caller == null && username == null && credentials == null) {
            return null;
        }
        try {
            Context securityCtx = null;
            securityCtx = this.prepareENC();
            if (securityCtx == null) {
                logger.error((Object)"No security context for authenticate(String, String)");
                return null;
            }
            SubjectSecurityManager securityMgr = (SubjectSecurityManager)securityCtx.lookup("securityMgr");
            if (!this.isSSODomain(securityMgr.getSecurityDomain())) {
                return super.authenticate(username, credentials);
            }
            principal = new SimplePrincipal(username);
            char[] passwordChars = null;
            if (credentials != null) {
                passwordChars = credentials.toCharArray();
            }
            SSOIdentityManagerService im = Lookup.getInstance().lookupSSOAgent().getSSOIdentityManager();
            String requester = "";
            SSOAgentRequest request = (SSOAgentRequest)AbstractSSOAgent._currentRequest.get();
            if (request != null) {
                requester = request.getRequester();
            } else {
                logger.warn((Object)"No SSO Agent request found in thread local variable, can't identify requester");
            }
            ssoUser = im.findUserInSession(requester, username);
            if (ssoUser != null) {
                logger.debug((Object)("User: " + username + " is authenticated"));
                Subject subject = new Subject();
                subject.getPrincipals().add((Principal)ssoUser);
                logger.warn((Object)"WARN Cannot identify requester!");
                SSORole[] ssoRolePrincipals = im.findRolesBySSOSessionId(requester, username);
                BaseRoleImpl targetGrp = new BaseRoleImpl("Roles");
                for (int i = 0; i < ssoRolePrincipals.length; ++i) {
                    subject.getPrincipals().add((Principal)ssoRolePrincipals[i]);
                    targetGrp.addMember((Principal)ssoRolePrincipals[i]);
                }
                subject.getPrincipals().add((Principal)targetGrp);
                logger.debug((Object)("Authenticated Subject: " + subject));
                JBossSecurityAssociationActions.setPrincipalInfo((Principal)ssoUser, passwordChars, subject);
                RealmMapping rm = (RealmMapping)securityCtx.lookup("realmMapping");
                SSOUser oldPrincipal = ssoUser;
                principal = rm.getPrincipal((Principal)oldPrincipal);
                logger.debug((Object)("Mapped from input principal: " + oldPrincipal + " to: " + principal));
                if (!principal.equals(oldPrincipal)) {
                    this._userPrincipalMap.put(principal, oldPrincipal);
                }
            } else {
                principal = null;
                logger.debug((Object)("User: " + username + " is NOT authenticated"));
            }
        }
        catch (NamingException e) {
            principal = null;
            logger.error((Object)"Error during authenticate", (Throwable)e);
        }
        catch (SSOIdentityException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getMessage());
            }
            principal = null;
        }
        catch (Exception e) {
            logger.error((Object)("Session authentication failed : " + username), (Throwable)e);
            throw new RuntimeException("Fatal error authenticating session : " + e);
        }
        logger.debug((Object)("End authenticate, principal=" + ssoUser));
        return ssoUser;
    }

    public boolean hasRole(Principal principal, String role) {
        boolean hasRole = false;
        try {
            Context securityCtx = null;
            securityCtx = this.prepareENC();
            if (securityCtx == null) {
                logger.error((Object)"No security context for authenticate(String, String)");
                return false;
            }
            logger.debug((Object)("hasRole(" + principal + "," + role + ")"));
            SubjectSecurityManager securityMgr = (SubjectSecurityManager)securityCtx.lookup("securityMgr");
            if (!this.isSSODomain(securityMgr.getSecurityDomain())) {
                return super.hasRole(principal, role);
            }
            Subject activeSubject = securityMgr.getActiveSubject();
            logger.debug((Object)("Authenticated Subject: " + activeSubject));
            CatalinaSSOUser ssoUser = CatalinaSSOUser.newInstance((Realm)this, (Subject)activeSubject);
            hasRole = super.hasRole((Principal)ssoUser, role);
        }
        catch (NamingException e) {
            principal = null;
            logger.error((Object)"Error during authenticate", (Throwable)e);
        }
        return hasRole;
    }

    public Principal authenticate(X509Certificate[] certs) {
        logger.debug((Object)"authenticate(X509Certificate[]), Begin");
        try {
            this.prepareENC();
            return super.authenticate(certs);
        }
        catch (Exception ne) {
            logger.error((Object)"Cannot create ENC Context");
            logger.debug((Object)"authenticate(), Emd");
            return null;
        }
    }

    protected Context prepareENC() throws NamingException {
        Context envCtx;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"JBossCatalinaRealm.prepareENC, Start");
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InitialContext iniCtx = new InitialContext();
        boolean securityContextExists = false;
        boolean isJaasSecurityManager = false;
        try {
            envCtx = (Context)iniCtx.lookup("java:comp/env");
            Context securityCtx = (Context)envCtx.lookup("security");
            securityContextExists = true;
            AuthenticationManager securityMgr = (AuthenticationManager)securityCtx.lookup("securityMgr");
            if (!(securityMgr instanceof JaasSecurityManager)) {
                Util.unbind((Context)envCtx, (String)"security");
            } else {
                isJaasSecurityManager = true;
            }
        }
        catch (NamingException e) {
            // empty catch block
        }
        envCtx = null;
        if (!securityContextExists) {
            Thread currentThread = Thread.currentThread();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating ENC using ClassLoader: " + loader));
            }
            for (ClassLoader parent = loader.getParent(); parent != null; parent = parent.getParent()) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)(".." + parent));
            }
            envCtx = (Context)iniCtx.lookup("java:comp");
            envCtx = envCtx.createSubcontext("env");
        } else {
            envCtx = (Context)iniCtx.lookup("java:comp/env");
        }
        if (!isJaasSecurityManager) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Linking security/securityMgr to JNDI name: java:/jaas/josso");
            }
            Util.bind((Context)envCtx, (String)"security/securityMgr", (Object)new LinkRef(JOSSO_SECURITY_DOMAIN));
            Util.bind((Context)envCtx, (String)"security/realmMapping", (Object)new LinkRef(JOSSO_SECURITY_DOMAIN));
            Util.bind((Context)envCtx, (String)"security/security-domain", (Object)new LinkRef(JOSSO_SECURITY_DOMAIN));
            Util.bind((Context)envCtx, (String)"security/subject", (Object)new LinkRef("java:/jaas/josso/subject"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"JBossCatalinaRealm.prepareENC, End");
        }
        return (Context)iniCtx.lookup("java:comp/env/security");
    }
}

