/*
 * Decompiled with CFR 0.152.
 */
package org.josso.jb5.agent;

import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.apache.catalina.Realm;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.security.SecurityContext;
import org.jboss.web.tomcat.security.JBossWebRealm;
import org.josso.jb5.agent.CatalinaSSOUser;
import org.josso.jb5.agent.JBossSecurityAssociationActions;

public class JBossCatalinaRealm
extends JBossWebRealm {
    private static final Log logger = LogFactory.getLog(JBossCatalinaRealm.class);

    public boolean hasRole(Principal principal, String role) {
        boolean hasRole = false;
        logger.debug((Object)("hasRole(" + principal + "," + role + ")"));
        try {
            SecurityContext sc = JBossSecurityAssociationActions.getSecurityContext();
            if (!this.isSSODomain(sc.getSecurityDomain())) {
                return super.hasRole(principal, role);
            }
            Subject activeSubject = (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
            logger.debug((Object)("Authenticated Subject: " + activeSubject));
            CatalinaSSOUser ssoUser = CatalinaSSOUser.newInstance((Realm)this, activeSubject);
            hasRole = super.hasRole((Principal)((Object)ssoUser), role);
        }
        catch (NullPointerException npe) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)npe);
            }
            hasRole = super.hasRole(principal, role);
        }
        catch (PolicyContextException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return hasRole;
    }

    protected boolean isSSODomain(String domain) {
        boolean isSSODomain = "josso".equals(domain);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(" JBoss Security Domain [" + domain + "] is" + (isSSODomain ? "" : " not") + " under SSO Control"));
        }
        return isSSODomain;
    }
}

