/*
 * Decompiled with CFR 0.152.
 */
package org.josso.jb5.agent;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;

class JBossSecurityAssociationActions {
    JBossSecurityAssociationActions() {
    }

    static SecurityContext getSecurityContext() {
        return (SecurityContext)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static void setPrincipalInfo(Principal principal, Object credential, Subject subject) {
        SetPrincipalInfoAction action = new SetPrincipalInfoAction(principal, credential, subject);
        AccessController.doPrivileged(action);
    }

    static Subject getSubject() {
        Subject subject = (Subject)AccessController.doPrivileged(GetSubjectAction.ACTION);
        return subject;
    }

    private static class GetSubjectAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetSubjectAction();

        private GetSubjectAction() {
        }

        public Object run() {
            SecurityContext sc = JBossSecurityAssociationActions.getSecurityContext();
            if (sc == null) {
                throw new IllegalStateException("Security Context is null");
            }
            return sc.getUtil().getSubject();
        }
    }

    private static class SetPrincipalInfoAction
    implements PrivilegedAction {
        Principal principal;
        Object credential;
        Subject subject;

        SetPrincipalInfoAction(Principal principal, Object credential, Subject subject) {
            this.principal = principal;
            this.credential = credential;
            this.subject = subject;
        }

        public Object run() {
            SecurityContext sc = JBossSecurityAssociationActions.getSecurityContext();
            if (sc == null) {
                throw new IllegalStateException("Security Context has not been set");
            }
            sc.getUtil().createSubjectInfo(this.principal, this.credential, this.subject);
            this.credential = null;
            this.principal = null;
            this.subject = null;
            return null;
        }
    }
}

