/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.audit.service.handler;

import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.audit.SSOAuditTrail;
import org.josso.gateway.audit.service.handler.BaseAuditTrailHandler;

public class LoggerAuditTrailHandler
extends BaseAuditTrailHandler {
    private Log trailsLogger = LogFactory.getLog(LoggerAuditTrailHandler.class);
    private String category;

    public int handle(SSOAuditTrail trail) {
        StringBuffer line = new StringBuffer();
        line.append(trail.getTime()).append(" - ").append(trail.getCategory()).append(" - ").append(trail.getSeverity());
        line.append(" - ").append(trail.getSubject() == null ? "" : trail.getSubject()).append(" - ").append(trail.getAction()).append("=").append(trail.getOutcome());
        Properties properties = trail.getProperties();
        Enumeration<?> names = properties.propertyNames();
        if (names.hasMoreElements()) {
            line.append(" - ");
        }
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            String value = properties.getProperty(key);
            line.append(key).append("=").append(value);
            if (!names.hasMoreElements()) continue;
            line.append(",");
        }
        if (trail.getError() != null) {
            line.append(" - ERROR:").append(trail.getError().getMessage()).append(":").append(trail.getError().getClass().getName());
            if (trail.getError().getCause() != null) {
                line.append(" ERROR_CAUSE:").append(trail.getError().getCause().getMessage()).append(":").append(trail.getError().getClass().getName());
            }
        }
        this.trailsLogger.info((Object)line);
        return 1;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
        this.trailsLogger = LogFactory.getLog((String)category);
    }
}

