/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.identity.service.store;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.auth.Credential;
import org.josso.auth.CredentialKey;
import org.josso.auth.CredentialProvider;
import org.josso.gateway.SSOException;
import org.josso.gateway.SSONameValuePair;
import org.josso.gateway.identity.exceptions.NoSuchRoleException;
import org.josso.gateway.identity.exceptions.NoSuchUserException;
import org.josso.gateway.identity.exceptions.SSOIdentityException;
import org.josso.gateway.identity.service.BaseRole;
import org.josso.gateway.identity.service.BaseRoleImpl;
import org.josso.gateway.identity.service.BaseUser;
import org.josso.gateway.identity.service.BaseUserImpl;
import org.josso.gateway.identity.service.store.AbstractStore;
import org.josso.gateway.identity.service.store.ExtendedIdentityStore;
import org.josso.gateway.identity.service.store.RoleKey;
import org.josso.gateway.identity.service.store.SimpleRoleKey;
import org.josso.gateway.identity.service.store.SimpleUserKey;
import org.josso.gateway.identity.service.store.UserKey;
import org.josso.selfservices.ChallengeResponseCredential;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryIdentityStore
extends AbstractStore
implements ExtendedIdentityStore {
    private static final Log logger = LogFactory.getLog(MemoryIdentityStore.class);
    private Map<String, Element> _roles;
    private Map<String, Element> _users;
    private Map<String, Set<String>> _userRoles;
    private Map<String, Element> _principalCredentials;
    private boolean _initialized;
    private String _credentialsFileName;
    private String _usersFileName;

    public MemoryIdentityStore() {
        logger.debug((Object)"Creating new MemoryIdentityStore");
        this._users = new HashMap<String, Element>(7);
        this._userRoles = new HashMap<String, Set<String>>(11);
        this._roles = new HashMap<String, Element>(11);
        this._principalCredentials = new HashMap<String, Element>(11);
        this._initialized = false;
    }

    public synchronized void initialize() {
        try {
            if (this._usersFileName != null) {
                this.loadUsersData(this._usersFileName);
            }
            if (this._credentialsFileName != null) {
                this.loadCredentialsData(this._credentialsFileName);
            }
            this._initialized = true;
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            throw new RuntimeException("Can't initialize memory store : " + e.getMessage(), e);
        }
    }

    protected void loadUsersData(String fName) throws Exception {
        logger.info((Object)("Reading users from : " + fName));
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(((Object)((Object)this)).getClass().getResourceAsStream("/" + fName));
        doc.getDocumentElement().normalize();
        logger.debug((Object)("Root element of the doc is " + doc.getDocumentElement().getNodeName()));
        this.loadRoles(doc);
        logger.info((Object)("Loaded " + this._roles.size() + " roles from : " + fName));
        this.loadUsers(doc);
        logger.info((Object)("Loaded " + this._users.size() + " users from : " + fName));
    }

    protected void loadRoles(Document doc) throws SSOException {
        NodeList listOfRoles = doc.getElementsByTagName("role");
        int totalRoles = listOfRoles.getLength();
        logger.debug((Object)("Total roles: " + totalRoles));
        for (int i = 0; i < listOfRoles.getLength(); ++i) {
            Node roleNode = listOfRoles.item(i);
            if (roleNode.getNodeType() != 1) continue;
            Element domRole = (Element)roleNode;
            Element domName = (Element)domRole.getElementsByTagName("name").item(0);
            logger.debug((Object)("Storing role for name : [" + this.getTextContent(domName) + "]"));
            this._roles.put(this.getTextContent(domName), domRole);
        }
    }

    protected void loadUsers(Document doc) throws Exception {
        NodeList listOfUsers = doc.getElementsByTagName("user");
        int totalUsers = listOfUsers.getLength();
        logger.debug((Object)("Total users: " + totalUsers));
        for (int i = 0; i < listOfUsers.getLength(); ++i) {
            Node userNode = listOfUsers.item(i);
            if (userNode.getNodeType() != 1) continue;
            Element userElement = (Element)userNode;
            Node domName = userElement.getElementsByTagName("name").item(0);
            logger.debug((Object)("Storing user for name : " + this.getTextContent(domName)));
            this._users.put(this.getTextContent(domName), userElement);
        }
    }

    protected void loadCredentialsData(String fName) throws Exception {
        logger.info((Object)("Reading credentials from : " + fName));
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(((Object)((Object)this)).getClass().getResourceAsStream("/" + fName));
        doc.getDocumentElement().normalize();
        this.loadCredentials(doc);
        logger.info((Object)("Loaded " + this._principalCredentials.size() + " credential sets from : " + fName));
    }

    protected void loadCredentials(Document doc) throws Exception {
        NodeList credentialSetLst = doc.getElementsByTagName("credential-set");
        int totalCredentials = credentialSetLst.getLength();
        logger.debug((Object)("Total credential sets: " + totalCredentials));
        for (int i = 0; i < credentialSetLst.getLength(); ++i) {
            Element domCredentialSet = (Element)credentialSetLst.item(i);
            Node domKey = domCredentialSet.getElementsByTagName("key").item(0);
            if (domKey.getNodeType() != 1 || !domKey.getNodeName().equals("key")) {
                throw new SSOIdentityException("Credential set definitions need a 'key' element [" + domKey.getNodeName() + "]");
            }
            String key = this.getTextContent(domKey);
            logger.info((Object)("Storing credentials for key : " + key));
            this._principalCredentials.put(key, domCredentialSet);
        }
    }

    protected Collection<BaseUser> listUsers() throws SSOIdentityException {
        if (!this._initialized) {
            this.initialize();
        }
        Collection<Element> domUsers = this._users.values();
        ArrayList<BaseUser> ssoUsers = new ArrayList<BaseUser>(domUsers.size());
        for (Element domUser : domUsers) {
            ssoUsers.add(this.toBaseUser(domUser));
        }
        return ssoUsers;
    }

    public synchronized BaseUser loadUser(UserKey key) throws NoSuchUserException, SSOIdentityException {
        if (!this._initialized) {
            this.initialize();
        }
        if (!(key instanceof SimpleUserKey)) {
            throw new SSOIdentityException("Unsupported key type : " + key.getClass().getName());
        }
        Element domUser = this._users.get(((SimpleUserKey)key).getId());
        if (domUser == null) {
            for (Map.Entry<String, Element> entry : this._users.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(((SimpleUserKey)key).getId())) continue;
                domUser = entry.getValue();
                break;
            }
        }
        if (domUser == null) {
            throw new NoSuchUserException(key);
        }
        BaseUser user = this.toBaseUser(domUser);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[load(" + key + ")] : ok"));
        }
        return user;
    }

    public synchronized BaseRole[] findRolesByUserKey(UserKey key) throws SSOIdentityException {
        if (!this._initialized) {
            this.initialize();
        }
        ArrayList<BaseRole> roles = new ArrayList<BaseRole>();
        SimpleUserKey simpleKey = (SimpleUserKey)key;
        Set<String> roleNames = this._userRoles.get(simpleKey.getId());
        if (roleNames != null) {
            for (String roleName : roleNames) {
                BaseRole role = this.findRoleByName(roleName);
                if (role == null) {
                    throw new SSOIdentityException("Role '" + roleName + "' declared for user '" + key + "' not defined");
                }
                roles.add(role);
            }
        }
        return roles.toArray(new BaseRole[roles.size()]);
    }

    public String loadUsernameByRelayCredential(ChallengeResponseCredential cred) throws SSOIdentityException {
        logger.debug((Object)("Looking for user with " + cred.getId() + "=[" + cred.getResponse() + "]"));
        Collection<BaseUser> users = this.listUsers();
        for (BaseUser user : users) {
            SSONameValuePair[] props = user.getProperties();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Checking user : " + user.getName() + " with " + props.length + " properties."));
            }
            if (props == null) continue;
            for (SSONameValuePair prop : props) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Checking property : " + prop.getName() + "=[" + prop.getValue() + "]"));
                }
                if (!prop.getName().equals(cred.getId()) || !prop.getValue().equals(cred.getResponse())) continue;
                return user.getName();
            }
        }
        return null;
    }

    public void updateAccountPassword(UserKey key, Credential newPassword) {
    }

    public Credential[] loadCredentials(CredentialKey key, CredentialProvider cp) throws SSOIdentityException {
        if (!this._initialized) {
            this.initialize();
        }
        if (!(key instanceof SimpleUserKey)) {
            throw new SSOIdentityException("Unsupported key type : " + key.getClass().getName());
        }
        SimpleUserKey simpleKey = (SimpleUserKey)key;
        Element credentialElement = this._principalCredentials.get(simpleKey.getId());
        if (credentialElement == null) {
            for (Map.Entry<String, Element> entry : this._principalCredentials.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(simpleKey.getId())) continue;
                credentialElement = entry.getValue();
                break;
            }
        }
        Credential[] creds = this.toCredentials(credentialElement, cp);
        logger.debug((Object)("Found " + creds.length + " credentials!"));
        if (logger.isDebugEnabled()) {
            for (int i = 0; i < creds.length; ++i) {
                Credential cred = creds[i];
                logger.debug((Object)("Credential[" + i + "]=" + creds[i]));
            }
        }
        return creds;
    }

    protected Credential[] toCredentials(Element domCredentialSet, CredentialProvider cp) throws SSOIdentityException {
        ArrayList<Credential> creds = new ArrayList<Credential>();
        if (domCredentialSet == null) {
            return creds.toArray(new Credential[creds.size()]);
        }
        NodeList domCredentials = domCredentialSet.getElementsByTagName("credential");
        for (int i = 0; i < domCredentials.getLength(); ++i) {
            Credential c;
            Element domCredential = (Element)domCredentials.item(i);
            if (domCredential.getNodeType() != 1 || !domCredential.getNodeName().equals("credential")) continue;
            Node domName = domCredential.getElementsByTagName("name").item(0);
            if (domName.getNodeType() != 1 || !domName.getNodeName().equals("name")) {
                throw new SSOIdentityException("Credential definitions need a 'name' and 'value' element");
            }
            Node domValue = domCredential.getElementsByTagName("value").item(0);
            if (domValue.getNodeType() != 1 || !domValue.getNodeName().equals("value")) {
                throw new SSOIdentityException("Credential definitions need a 'name' and 'value' element");
            }
            String name = this.getTextContent(domName);
            String value = this.getTextContent(domValue);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating credential [" + name + "/" + value + "] "));
            }
            if ((c = cp.newCredential(name, (Object)value)) == null) continue;
            creds.add(c);
        }
        return creds.toArray(new Credential[creds.size()]);
    }

    protected BaseRole toBaseRole(Element domRole) throws SSOIdentityException {
        Node domName = domRole.getElementsByTagName("name").item(0);
        if (domName.getNodeType() != 1 || !domName.getNodeName().equals("name")) {
            throw new SSOIdentityException("Role definitions need a 'name' element");
        }
        return new BaseRoleImpl(this.getTextContent(domName));
    }

    protected BaseUser toBaseUser(Element domUser) throws SSOIdentityException {
        Node domUsername = domUser.getElementsByTagName("name").item(0);
        if (domUsername.getNodeType() != 1 || !domUsername.getNodeName().equals("name")) {
            throw new SSOIdentityException("User definitions need a 'name'");
        }
        String username = this.getTextContent(domUsername);
        BaseUserImpl user = new BaseUserImpl();
        SimpleUserKey key = new SimpleUserKey(username);
        user.setName(username);
        NodeList propertiesLst = domUser.getElementsByTagName("property");
        for (int i = 0; i < propertiesLst.getLength(); ++i) {
            Element domProperty = (Element)propertiesLst.item(i);
            Node domName = domProperty.getElementsByTagName("name").item(0);
            if (domName.getNodeType() != 1 || !domName.getNodeName().equals("name")) {
                throw new SSOIdentityException("Property definitions need a 'name' and 'value' element");
            }
            Node domValue = domProperty.getElementsByTagName("value").item(0);
            if (domValue.getNodeType() != 1 || !domValue.getNodeName().equals("value")) {
                throw new SSOIdentityException("Property definitions need a 'name' and 'value' element");
            }
            String name = this.getTextContent(domName);
            String value = this.getTextContent(domValue);
            user.addProperty(new SSONameValuePair(name, value));
        }
        NodeList rolesLst = domUser.getElementsByTagName("roles");
        if (rolesLst.getLength() > 1) {
            throw new SSOIdentityException("Only one 'roles' element can be defined for a user");
        }
        if (rolesLst.getLength() > 0) {
            HashSet<String> roles = new HashSet<String>();
            Node domRoles = rolesLst.item(0);
            String stRoles = this.getTextContent(domRoles);
            StringTokenizer st = new StringTokenizer(stRoles != null ? stRoles : "", ",");
            while (st.hasMoreTokens()) {
                String roleName = st.nextToken().trim();
                BaseRole role = this.findRoleByName(roleName);
                roles.add(roleName);
                logger.debug((Object)("User is in role : " + role));
            }
            this._userRoles.put(username, roles);
        }
        return user;
    }

    protected CredentialKey createCredentialKey(String name) {
        return new SimpleUserKey(name);
    }

    public synchronized Set<String> getRoleKeys() throws SSOIdentityException {
        return this._roles.keySet();
    }

    public synchronized BaseRole loadRole(RoleKey roleKey) throws NoSuchRoleException, SSOIdentityException {
        BaseRole role = (BaseRole)this._roles.get(roleKey);
        if (role == null) {
            throw new NoSuchRoleException(roleKey);
        }
        return role;
    }

    public synchronized BaseRole findRoleByName(String name) throws SSOIdentityException {
        Element domRole = this._roles.get(name);
        if (domRole == null) {
            throw new SSOIdentityException("No such role : " + name);
        }
        return this.toBaseRole(domRole);
    }

    protected UserKey createUserKey(BaseUser user) {
        return new SimpleUserKey(user.getName());
    }

    protected BaseRole createRole(String name) {
        BaseRoleImpl role = new BaseRoleImpl();
        role.setName(name);
        return role;
    }

    protected RoleKey createRoleKey(BaseRole role) {
        return new SimpleRoleKey(role.getName());
    }

    public void setCredentialsFileName(String credentialsFileName) {
        logger.debug((Object)("Setting crednetials file name to : " + credentialsFileName));
        this._credentialsFileName = credentialsFileName;
    }

    public String getCredentialsFileName() {
        return this._credentialsFileName;
    }

    public void setUsersFileName(String usersFileName) {
        logger.debug((Object)("Setting users file name to : " + usersFileName));
        this._usersFileName = usersFileName;
    }

    protected String getTextContent(Node node) {
        try {
            Method getTextContent = node.getClass().getMethod("getTextContent", new Class[0]);
            return (String)getTextContent.invoke((Object)node, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            logger.debug((Object)"Using old DOM Java Api to get Node text content");
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 3) continue;
            return child.getNodeValue();
        }
        return null;
    }
}

