/*
 * Decompiled with CFR 0.152.
 */
package org.josso.auth.scheme;

import java.security.Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.auth.Credential;
import org.josso.auth.CredentialProvider;
import org.josso.auth.SimplePrincipal;
import org.josso.auth.exceptions.AuthenticationFailureException;
import org.josso.auth.scheme.AbstractAuthenticationScheme;
import org.josso.auth.scheme.NtlmCredentialProvider;
import org.josso.gateway.protocol.handler.NtlmProtocolHandler;

public class NtlmAuthScheme
extends AbstractAuthenticationScheme {
    private static final Log logger = LogFactory.getLog(NtlmAuthScheme.class);

    public NtlmAuthScheme() {
        this.setName("ntlm-authentication");
    }

    protected CredentialProvider doMakeCredentialProvider() {
        return new NtlmCredentialProvider();
    }

    public boolean authenticate() throws AuthenticationFailureException {
        try {
            NtlmProtocolHandler ph = NtlmProtocolHandler.getInstance();
            this.setAuthenticated(ph.authenticate(this._inputCredentials));
            return this.isAuthenticated();
        }
        catch (AuthenticationFailureException afe) {
            throw afe;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public Principal getPrincipal() {
        return new SimplePrincipal(NtlmCredentialProvider.retreiveCredentialName("NtlmPasswordAuthentication", this._inputCredentials));
    }

    public Principal getPrincipal(Credential[] credentials) {
        return new SimplePrincipal(NtlmCredentialProvider.retreiveCredentialName("NtlmPasswordAuthentication", credentials));
    }

    public Credential[] getPrivateCredentials() {
        Credential c = NtlmCredentialProvider.retreiveCredential("NtlmPasswordAuthentication", this._inputCredentials);
        if (c == null) {
            return new Credential[0];
        }
        return new Credential[]{c};
    }

    public Credential[] getPublicCredentials() {
        return this.getPrivateCredentials();
    }
}

