/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.GatewayServiceLocator;
import org.josso.gateway.WebserviceClientAuthentication;
import org.josso.gateway.identity.service.SSOIdentityManagerService;
import org.josso.gateway.identity.service.SSOIdentityProviderService;
import org.josso.gateway.identity.service.WebserviceSSOIdentityManager;
import org.josso.gateway.identity.service.WebserviceSSOIdentityProvider;
import org.josso.gateway.session.service.SSOSessionManagerService;
import org.josso.gateway.session.service.WebserviceSSOSessionManager;
import org.josso.gateway.ws._1_2.wsdl.SSOIdentityManager;
import org.josso.gateway.ws._1_2.wsdl.SSOIdentityManagerWSLocator;
import org.josso.gateway.ws._1_2.wsdl.SSOIdentityProvider;
import org.josso.gateway.ws._1_2.wsdl.SSOIdentityProviderWSLocator;
import org.josso.gateway.ws._1_2.wsdl.SSOSessionManager;
import org.josso.gateway.ws._1_2.wsdl.SSOSessionManagerWSLocator;

public class WebserviceGatewayServiceLocator
extends GatewayServiceLocator {
    private static final Log logger = LogFactory.getLog(WebserviceGatewayServiceLocator.class);

    public SSOSessionManagerService getSSOSessionManager() throws Exception {
        SSOSessionManagerWSLocator ssoManagerServiceLocator = new SSOSessionManagerWSLocator();
        String smEndpoint = this.getSSOSessionManagerEndpoint();
        logger.debug((Object)("Using SSOSessionManager endpoint '" + smEndpoint + "'"));
        ssoManagerServiceLocator.setSSOSessionManagerSoapEndpointAddress(smEndpoint);
        SSOSessionManager ssoSessionManagerWebservice = ssoManagerServiceLocator.getSSOSessionManagerSoap();
        WebserviceSSOSessionManager wsm = new WebserviceSSOSessionManager(ssoSessionManagerWebservice);
        return wsm;
    }

    public SSOIdentityManagerService getSSOIdentityManager() throws Exception {
        SSOIdentityManagerWSLocator ssoIdentityManagerServiceLocator = new SSOIdentityManagerWSLocator();
        String imEndpoint = this.getSSOIdentityManagerEndpoint();
        logger.debug((Object)("Using SSOIdentityManager endpoint '" + imEndpoint + "'"));
        ssoIdentityManagerServiceLocator.setSSOIdentityManagerSoapEndpointAddress(imEndpoint);
        SSOIdentityManager ssoIdentityManagerWebservice = ssoIdentityManagerServiceLocator.getSSOIdentityManagerSoap();
        WebserviceSSOIdentityManager wim = new WebserviceSSOIdentityManager(ssoIdentityManagerWebservice);
        return wim;
    }

    public SSOIdentityProviderService getSSOIdentityProvider() throws Exception {
        SSOIdentityProviderWSLocator ssoIdentityProviderServiceLocator = new SSOIdentityProviderWSLocator();
        String ipEndpoint = this.getSSOIdentityProviderEndpoint();
        logger.debug((Object)("Using SSOIdentityProvider endpoint '" + ipEndpoint + "'"));
        ssoIdentityProviderServiceLocator.setSSOIdentityProviderSoapEndpointAddress(ipEndpoint);
        SSOIdentityProvider ssoIdentityProviderWebservice = ssoIdentityProviderServiceLocator.getSSOIdentityProviderSoap();
        WebserviceSSOIdentityProvider wip = new WebserviceSSOIdentityProvider(ssoIdentityProviderWebservice);
        return wip;
    }

    public void setUsername(String username) {
        super.setUsername(username);
        WebserviceClientAuthentication.setUsername(username);
    }

    public void setPassword(String password) {
        super.setPassword(password);
        WebserviceClientAuthentication.setPassword(password);
    }
}

