/*
 * Decompiled with CFR 0.152.
 */
package org.josso.servlet.agent;

import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.agent.SSOAgentRequest;
import org.josso.agent.SingleSignOnEntry;
import org.josso.agent.http.JOSSOSecurityContext;
import org.josso.agent.http.JaasHttpSSOAgent;
import org.josso.agent.http.SSOGatewayHandler;
import org.josso.gateway.identity.SSORole;
import org.josso.servlet.agent.GenericServletLocalSession;
import org.josso.servlet.agent.GenericServletSSOAgentRequest;
import org.josso.servlet.agent.jaas.SSOGatewayLoginModule;

public class GenericServletSSOAgent
extends JaasHttpSSOAgent {
    private static final Log log = LogFactory.getLog(GenericServletSSOAgent.class);
    private boolean _disableJaas = false;

    protected SingleSignOnEntry execute(SSOAgentRequest request) {
        GenericServletSSOAgentRequest r = (GenericServletSSOAgentRequest)request;
        GenericServletLocalSession localSession = (GenericServletLocalSession)r.getLocalSession();
        SingleSignOnEntry entry = super.execute(request);
        if (entry != null) {
            if (r.getSecurityContext() != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Publishing JOSSO Security Context instance in session [" + (entry != null ? entry.ssoId : "<NO-SSO-ID>") + "]"));
                }
                localSession.setSecurityContext(r.getSecurityContext());
            }
        } else if (localSession != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Clearing JOSSO Security Context for session [" + localSession.getId() + "]"));
            }
            localSession.setSecurityContext(null);
            r.setSecurityContext(null);
        }
        return entry;
    }

    protected Principal authenticate(SSOAgentRequest request) {
        JOSSOSecurityContext ctx;
        String ssoSessionId = request.getSessionId();
        log.debug((Object)("authenticate requester = " + request.getRequester()));
        Principal ssoUser = null;
        if (this._disableJaas) {
            SSOGatewayLoginModule m = new SSOGatewayLoginModule();
            try {
                Subject s = new Subject();
                SSOGatewayHandler ch = new SSOGatewayHandler(request.getRequester(), ssoSessionId, request.getNodeId());
                m.initialize(s, (CallbackHandler)ch, (Map)null, (Map)null);
                m.login();
                m.commit();
                ctx = new JOSSOSecurityContext(s);
                ssoUser = ctx.getCurrentPrincipal();
            }
            catch (LoginException e) {
                try {
                    m.abort();
                }
                catch (LoginException e1) {
                    log.error((Object)e1.getMessage(), (Throwable)e1);
                }
                log.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
        ssoUser = super.authenticate(request);
        if (ssoUser != null) {
            Subject subject = new Subject();
            subject.getPrincipals().add(ssoUser);
            SSORole[] ssoRolePrincipals = this.getRoleSets(request.getRequester(), ssoSessionId, request.getNodeId());
            for (int i = 0; i < ssoRolePrincipals.length; ++i) {
                subject.getPrincipals().add((Principal)ssoRolePrincipals[i]);
                log.debug((Object)("Added SSORole Principal to the Subject : " + ssoRolePrincipals[i]));
            }
            GenericServletSSOAgentRequest r = (GenericServletSSOAgentRequest)request;
            ctx = new JOSSOSecurityContext(subject);
            ctx.setSSOSession(ssoSessionId);
            r.setSecurityContext(ctx);
        }
        return ssoUser;
    }

    protected boolean isAuthenticationAlwaysRequired() {
        return true;
    }

    public boolean isDisableJaas() {
        return this._disableJaas;
    }

    public void setDisableJaas(boolean disableJaas) {
        this._disableJaas = disableJaas;
    }

    protected void log(String message) {
        log.debug((Object)message);
    }

    protected void log(String message, Throwable throwable) {
        log.debug((Object)message, throwable);
    }
}

