/*
 * Decompiled with CFR 0.152.
 */
package org.josso.selfservices.password.lostpassword;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.auth.exceptions.AuthenticationFailureException;
import org.josso.gateway.SSOException;
import org.josso.gateway.identity.SSOUser;
import org.josso.gateway.identity.exceptions.SSOIdentityException;
import org.josso.selfservices.ChallengeResponseCredential;
import org.josso.selfservices.password.PasswordManagementProcess;
import org.josso.selfservices.password.lostpassword.AbstractLostPasswordProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleLostPasswordProcess
extends AbstractLostPasswordProcess {
    private static final Log log = LogFactory.getLog(SimpleLostPasswordProcess.class);
    private String challengeId = "email";
    private String challengeText = "Email Address";

    public PasswordManagementProcess createNewProcess(String id) throws SSOException {
        SimpleLostPasswordProcess p = (SimpleLostPasswordProcess)super.createNewProcess(id);
        p.setChallengeId(this.challengeId);
        p.setChallengeText(this.challengeText);
        return p;
    }

    protected ChallengeResponseCredential[] createInitilaChallenges() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating challenge [" + this.challengeId + "] " + this.challengeText));
        }
        ChallengeResponseCredential email = new ChallengeResponseCredential(this.challengeId, this.challengeText);
        return new ChallengeResponseCredential[]{email};
    }

    protected SSOUser authenticate(Set<ChallengeResponseCredential> challenges) throws AuthenticationFailureException {
        ChallengeResponseCredential challenge = this.getChallenge(this.challengeId, challenges);
        if (challenge == null) {
            throw new AuthenticationFailureException("No challenge received : " + this.challengeId);
        }
        try {
            String username = this.getIdentityManager().findUsernameByRelayCredential(challenge);
            if (username == null) {
                throw new AuthenticationFailureException("No user found for provided challenges");
            }
            SSOUser user = this.findUserByUsername(username);
            log.debug((Object)("User found for " + username));
            return user;
        }
        catch (SSOIdentityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AuthenticationFailureException("No email received");
        }
    }

    public String getChallengeId() {
        return this.challengeId;
    }

    public void setChallengeId(String challengeId) {
        this.challengeId = challengeId;
    }

    public String getChallengeText() {
        return this.challengeText;
    }

    public void setChallengeText(String challengeText) {
        this.challengeText = challengeText;
    }
}

