/*
 * Decompiled with CFR 0.152.
 */
package org.josso.spring.security;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.GatewayServiceLocator;
import org.josso.gateway.identity.SSORole;
import org.josso.gateway.identity.SSOUser;
import org.josso.gateway.identity.exceptions.NoSuchUserException;
import org.josso.gateway.identity.exceptions.SSOIdentityException;
import org.josso.gateway.identity.service.SSOIdentityManagerService;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class JOSSOUserDetailsService
implements UserDetailsService {
    private static final Log logger = LogFactory.getLog(JOSSOUserDetailsService.class);
    private String _requester;
    private GatewayServiceLocator _gsl;
    private SSOIdentityManagerService _im;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        try {
            SSOUser user = this.getIdentityManager().findUserInSession(this._requester, username);
            SSORole[] roles = this._im.findRolesBySSOSessionId(this._requester, username);
            return this.toUserDetails(user, roles);
        }
        catch (NoSuchUserException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new UsernameNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (SSOIdentityException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new UsernameNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    protected UserDetails toUserDetails(SSOUser user, SSORole[] roles) {
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        for (int i = 0; i < roles.length; ++i) {
            SSORole role = roles[i];
            authorities.add(new SimpleGrantedAuthority(role.getName()));
        }
        User ud = new User(user.getName(), "NOT AVAILABLE UNDER JOSSO", true, true, true, true, authorities);
        return ud;
    }

    public String getRequester() {
        return this._requester;
    }

    public void setRequester(String requester) {
        this._requester = requester;
    }

    public GatewayServiceLocator getGatewayServiceLocator() {
        return this._gsl;
    }

    public void setGatewayServiceLocator(GatewayServiceLocator gsl) {
        this._gsl = gsl;
    }

    public SSOIdentityManagerService getIdentityManager() {
        if (this._im == null) {
            try {
                this._im = this._gsl.getSSOIdentityManager();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this._im;
    }
}

