/*
 * Decompiled with CFR 0.152.
 */
package org.josso.auth.scheme;

import java.io.ByteArrayInputStream;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.auth.Credential;
import org.josso.auth.CredentialProvider;
import org.josso.auth.SimplePrincipal;
import org.josso.auth.exceptions.SSOAuthenticationException;
import org.josso.auth.scheme.AbstractAuthenticationScheme;
import org.josso.auth.scheme.X509CertificateCredential;
import org.josso.auth.scheme.X509CertificateCredentialProvider;
import sun.security.util.DerValue;

public class X509CertificateAuthScheme
extends AbstractAuthenticationScheme {
    private static final Log logger = LogFactory.getLog(X509CertificateAuthScheme.class);
    private String _uidOID;

    public X509CertificateAuthScheme() {
        this.setName("strong-authentication");
    }

    public boolean authenticate() throws SSOAuthenticationException {
        this.setAuthenticated(false);
        X509Certificate x509Certificate = this.getX509Certificate(this._inputCredentials);
        if (x509Certificate == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"X.509 Certificate not provided");
            }
            return false;
        }
        X509Certificate knownX509Certificate = this.getX509Certificate(this.getKnownCredentials());
        StringBuffer buf = new StringBuffer("\n\tSupplied Credential: ");
        buf.append(x509Certificate.getSerialNumber().toString(16));
        buf.append("\n\t\t");
        buf.append(x509Certificate.getSubjectDN().getName());
        buf.append("\n\n\tExisting Credential: ");
        if (knownX509Certificate != null) {
            buf.append(knownX509Certificate.getSerialNumber().toString(16));
            buf.append("\n\t\t");
            buf.append(knownX509Certificate.getSubjectDN().getName());
            buf.append("\n");
        }
        logger.debug((Object)buf.toString());
        if (!this.validateX509Certificate(x509Certificate, knownX509Certificate)) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[authenticate()], Principal authenticated : " + x509Certificate.getSubjectDN()));
        }
        this.setAuthenticated(true);
        return true;
    }

    protected CredentialProvider doMakeCredentialProvider() {
        return new X509CertificateCredentialProvider();
    }

    private X509Certificate buildX509Certificate(byte[] binaryCert) {
        X509Certificate cert = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(binaryCert);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)cf.generateCertificate(bais);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Building X.509 certificate result :\n " + cert));
            }
        }
        catch (CertificateException ce) {
            logger.error((Object)"Error instantiating X.509 Certificate", (Throwable)ce);
        }
        return cert;
    }

    private X509Certificate buildX509Certificate(String plainCert) {
        return this.buildX509Certificate(plainCert.getBytes());
    }

    public Credential[] getPrivateCredentials() {
        X509CertificateCredential c = this.getX509CertificateCredential(this._inputCredentials);
        if (c == null) {
            return new Credential[0];
        }
        Credential[] r = new Credential[]{c};
        return r;
    }

    public Credential[] getPublicCredentials() {
        X509CertificateCredential c = this.getX509CertificateCredential(this._inputCredentials);
        if (c == null) {
            return new Credential[0];
        }
        Credential[] r = new Credential[]{c};
        return r;
    }

    public Principal getPrincipal() {
        return this.getPrincipal(this._inputCredentials);
    }

    public Principal getPrincipal(Credential[] credentials) {
        Principal p = this.getX509Certificate(credentials).getSubjectDN();
        SimplePrincipal targetPrincipal = null;
        if (this._uidOID == null) {
            HashMap compoundName = this.parseCompoundName(p.getName());
            String cn = (String)compoundName.get("cn");
            if (cn == null) {
                logger.error((Object)("Invalid Subject DN. Cannot create Principal : " + p.getName()));
            }
            targetPrincipal = new SimplePrincipal(cn);
        } else {
            try {
                byte[] oidValue = this.getOIDBitStringValueFromCert(this.getX509Certificate(credentials), this._uidOID);
                if (oidValue == null) {
                    logger.error((Object)("No value obtained for OID " + this._uidOID + ". Cannot create Principal : " + p.getName()));
                }
                targetPrincipal = new SimplePrincipal(new String(oidValue));
            }
            catch (Exception e) {
                logger.error((Object)("Fatal error obtaining UID value using OID " + this._uidOID + ". Cannot create Principal : " + p.getName()), (Throwable)e);
            }
        }
        return targetPrincipal;
    }

    protected X509CertificateCredential getX509CertificateCredential(Credential[] credentials) {
        for (int i = 0; i < credentials.length; ++i) {
            if (!(credentials[i] instanceof X509CertificateCredential)) continue;
            return (X509CertificateCredential)credentials[i];
        }
        return null;
    }

    protected X509Certificate getX509Certificate(Credential[] credentials) {
        X509CertificateCredential c = this.getX509CertificateCredential(credentials);
        if (c == null) {
            return null;
        }
        return (X509Certificate)c.getValue();
    }

    protected boolean validateX509Certificate(X509Certificate inputX509Certificate, X509Certificate expectedX509Certificate) {
        if (inputX509Certificate == null && expectedX509Certificate == null) {
            return false;
        }
        return inputX509Certificate.equals(expectedX509Certificate);
    }

    private HashMap parseCompoundName(String s) {
        Object valArray = null;
        if (s == null) {
            throw new IllegalArgumentException();
        }
        HashMap<String, String> hm = new HashMap<String, String>();
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String pair = st.nextToken();
            int pos = pair.indexOf(61);
            if (pos == -1) {
                throw new IllegalArgumentException();
            }
            String key = pair.substring(0, pos).trim().toLowerCase();
            String val = pair.substring(pos + 1, pair.length()).trim();
            hm.put(key, val);
        }
        return hm;
    }

    private byte[] getOIDBitStringValueFromCert(X509Certificate cert, String oid) throws Exception {
        byte[] derEncodedValue = cert.getExtensionValue(oid);
        byte[] extensionValue = null;
        DerValue dervalue = new DerValue(derEncodedValue);
        if (dervalue == null) {
            throw new IllegalArgumentException("extension not found for OID : " + oid);
        }
        if (dervalue.tag != 3) {
            throw new IllegalArgumentException("extension vaue for OID not of type BIT_STRING: " + oid);
        }
        extensionValue = dervalue.getBitString();
        byte[] extensionValueBytes = new byte[extensionValue.length - 2];
        System.arraycopy(extensionValue, 2, extensionValueBytes, 0, extensionValueBytes.length);
        return extensionValueBytes;
    }

    public void setUidOID(String uidOID) {
        this._uidOID = uidOID;
    }

    public String getUidOID() {
        return this._uidOID;
    }
}

