/*
 * Decompiled with CFR 0.152.
 */
package org.josso.auth.scheme;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.auth.Credential;
import org.josso.auth.CredentialProvider;
import org.josso.auth.scheme.X509CertificateCredential;

public class X509CertificateCredentialProvider
implements CredentialProvider {
    private static final Log logger = LogFactory.getLog(X509CertificateCredentialProvider.class);
    private static final String X509_CERTIFICATE_CREDENTIAL_NAME = "userCertificate";

    public Credential newCredential(String name, Object value) {
        if (name.equalsIgnoreCase(X509_CERTIFICATE_CREDENTIAL_NAME)) {
            if (value instanceof X509Certificate) {
                return new X509CertificateCredential(value);
            }
            if (value instanceof String) {
                X509Certificate cert = this.buildX509Certificate((String)value);
                return new X509CertificateCredential(cert);
            }
            X509Certificate cert = this.buildX509Certificate((byte[])value);
            return new X509CertificateCredential(cert);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unknown credential name : " + name));
        }
        return null;
    }

    public Credential newEncodedCredential(String name, Object value) {
        return this.newCredential(name, value);
    }

    private X509Certificate buildX509Certificate(byte[] binaryCert) {
        X509Certificate cert = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(binaryCert);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)cf.generateCertificate(bais);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Building X.509 certificate result :\n " + cert));
            }
        }
        catch (CertificateException ce) {
            logger.error((Object)"Error instantiating X.509 Certificate", (Throwable)ce);
        }
        return cert;
    }

    private X509Certificate buildX509Certificate(String plainCert) {
        return this.buildX509Certificate(plainCert.getBytes());
    }
}

